/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RetinalScannerBlockEntity
extends DisguisableBlockEntity
implements IViewActivated,
ITickingBlockEntity,
ILockable {
    private static GameProfileCache profileCache;
    private static MinecraftSessionService sessionService;
    private static Executor mainThreadExecutor;
    private Option.BooleanOption activatedByEntities = new Option.BooleanOption("activatedByEntities", false);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((RetinalScannerBlockEntity)this).m_58899_(), "signalLength", 60, 5, 400, 5, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private GameProfile ownerProfile;
    private int viewCooldown = 0;

    public RetinalScannerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.RETINAL_SCANNER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        this.checkView(level, pos);
    }

    @Override
    public boolean onEntityViewed(LivingEntity entity, BlockHitResult hitResult) {
        if (!this.isLocked() && !this.isDisabled()) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (state.m_61143_((net.minecraft.world.level.block.state.properties.Property)RetinalScannerBlock.FACING) != hitResult.m_82434_()) {
                return false;
            }
            if (!((Boolean)state.m_61143_((net.minecraft.world.level.block.state.properties.Property)RetinalScannerBlock.POWERED)).booleanValue() && !EntityUtils.isInvisible(entity)) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    Owner viewingPlayer = new Owner(player);
                    if (((Boolean)ConfigHandler.SERVER.trickScannersWithPlayerHeads.get()).booleanValue() && player.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42680_) {
                        viewingPlayer = PlayerUtils.getSkullOwner(player);
                    }
                    if (!this.isOwnedBy(viewingPlayer) && !this.isAllowed(viewingPlayer.getName())) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Block)SCContent.RETINAL_SCANNER.get()).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner().getName())), ChatFormatting.RED);
                        return true;
                    }
                    if (((Boolean)this.sendMessage.get()).booleanValue()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Block)SCContent.RETINAL_SCANNER.get()).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.hello", viewingPlayer.getName()), ChatFormatting.GREEN);
                    }
                } else if (this.activatedOnlyByPlayer()) {
                    return false;
                }
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((net.minecraft.world.level.block.state.properties.Property)RetinalScannerBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, (Block)SCContent.RETINAL_SCANNER.get());
                this.f_58857_.m_186460_(new BlockPos((Vec3i)this.f_58858_), (Block)SCContent.RETINAL_SCANNER.get(), this.getSignalLength());
                return true;
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isLocked() && ((Boolean)this.sendMessage.get()).booleanValue()) {
                MutableComponent blockName = Utils.localize(((Block)SCContent.RETINAL_SCANNER.get()).m_7705_(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, blockName, Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), ChatFormatting.DARK_RED, false);
            } else if (this.isDisabled()) {
                player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getDefaultViewCooldown() {
        return this.getSignalLength() + 30;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
        this.m_6596_();
    }

    @Override
    public boolean activatedOnlyByPlayer() {
        return (Boolean)this.activatedByEntities.get() == false;
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.activatedByEntities, this.sendMessage, this.signalLength, this.disabled};
    }

    public static void setProfileCache(GameProfileCache profileCache) {
        RetinalScannerBlockEntity.profileCache = profileCache;
    }

    public static void setSessionService(MinecraftSessionService sessionService) {
        RetinalScannerBlockEntity.sessionService = sessionService;
    }

    public static void setMainThreadExecutor(Executor mainThreadExecutor) {
        RetinalScannerBlockEntity.mainThreadExecutor = mainThreadExecutor;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!StringUtil.m_14408_((String)this.getOwner().getName()) && !this.getOwner().getName().equals("owner") && this.ownerProfile != null) {
            CompoundTag ownerProfileTag = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)ownerProfileTag, (GameProfile)this.ownerProfile);
            tag.m_128365_("ownerProfile", (Tag)ownerProfileTag);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("ownerProfile", 10)) {
            this.setPlayerProfile(NbtUtils.m_129228_((CompoundTag)tag.m_128469_("ownerProfile")));
        }
    }

    @Override
    public void onOwnerChanged(BlockState state, Level world, BlockPos pos, Player player) {
        this.setPlayerProfile(new GameProfile(null, this.getOwner().getName()));
        super.onOwnerChanged(state, world, pos, player);
    }

    @Nullable
    public GameProfile getPlayerProfile() {
        return this.ownerProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerProfile(@Nullable GameProfile profile) {
        RetinalScannerBlockEntity retinalScannerBlockEntity = this;
        synchronized (retinalScannerBlockEntity) {
            this.ownerProfile = profile;
        }
        this.updatePlayerProfile();
    }

    public void updatePlayerProfile() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            if (profileCache == null) {
                RetinalScannerBlockEntity.setProfileCache(ServerLifecycleHooks.getCurrentServer().m_129927_());
            }
            if (sessionService == null) {
                RetinalScannerBlockEntity.setSessionService(ServerLifecycleHooks.getCurrentServer().m_129925_());
            }
            if (mainThreadExecutor == null) {
                RetinalScannerBlockEntity.setMainThreadExecutor((Executor)ServerLifecycleHooks.getCurrentServer());
            }
        }
        this.updateGameProfile(this.ownerProfile, profile -> {
            this.ownerProfile = profile;
            this.m_6596_();
        });
    }

    private void updateGameProfile(GameProfile input, Consumer<GameProfile> onChanged) {
        if (!(!((Boolean)ConfigHandler.SERVER.retinalScannerFace.get()).booleanValue() || input == null || StringUtil.m_14408_((String)input.getName()) || input.isComplete() && input.getProperties().containsKey((Object)"textures") || profileCache == null || sessionService == null)) {
            profileCache.m_143967_(input.getName(), result -> Util.m_183991_().execute(() -> Util.m_137521_((Optional)result, gameProfile -> {
                Property textures = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
                if (textures == null) {
                    gameProfile = sessionService.fillProfileProperties(gameProfile, true);
                }
                GameProfile profile = gameProfile;
                mainThreadExecutor.execute(() -> {
                    profileCache.m_10991_(profile);
                    onChanged.accept(profile);
                });
            }, () -> mainThreadExecutor.execute(() -> onChanged.accept(input)))));
        } else {
            onChanged.accept(input);
        }
    }
}

