/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.OverlayToggleHandler;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class CameraController {
    @Deprecated
    private static double cameraSpeed = -1.0;
    public static CameraType previousCameraType;
    public static boolean resetOverlaysAfterDismount;
    private static ClientChunkCache.Storage cameraStorage;
    private static boolean chunksLoaded;
    private static int chunkLoadingDistance;
    private static boolean wasUpPressed;
    private static boolean wasDownPressed;
    private static boolean wasLeftPressed;
    private static boolean wasRightPressed;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        if (cameraEntity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)cameraEntity;
            Options options = Minecraft.m_91087_().f_91066_;
            if (event.phase == TickEvent.Phase.START) {
                wasUpPressed = options.f_92085_.m_90857_();
                if (wasUpPressed) {
                    options.f_92085_.m_7249_(false);
                }
                if (wasDownPressed = options.f_92087_.m_90857_()) {
                    options.f_92087_.m_7249_(false);
                }
                if (wasLeftPressed = options.f_92086_.m_90857_()) {
                    options.f_92086_.m_7249_(false);
                }
                if (wasRightPressed = options.f_92088_.m_90857_()) {
                    options.f_92088_.m_7249_(false);
                }
                if (options.f_92090_.m_90857_()) {
                    CameraController.dismount();
                    options.f_92090_.m_7249_(false);
                }
            } else if (event.phase == TickEvent.Phase.END) {
                if (wasUpPressed) {
                    CameraController.moveViewUp(cam);
                    options.f_92085_.m_7249_(true);
                }
                if (wasDownPressed) {
                    CameraController.moveViewDown(cam);
                    options.f_92087_.m_7249_(true);
                }
                if (wasLeftPressed) {
                    CameraController.moveViewHorizontally(cam, cam.m_146908_(), cam.m_146908_() - (float)CameraController.cameraSpeed() * cam.zoomAmount);
                    options.f_92086_.m_7249_(true);
                }
                if (wasRightPressed) {
                    CameraController.moveViewHorizontally(cam, cam.m_146908_(), cam.m_146908_() + (float)CameraController.cameraSpeed() * cam.zoomAmount);
                    options.f_92088_.m_7249_(true);
                }
                if (KeyBindings.cameraZoomIn.m_90857_()) {
                    CameraController.zoomIn(cam);
                } else if (KeyBindings.cameraZoomOut.m_90857_()) {
                    CameraController.zoomOut(cam);
                } else {
                    cam.zooming = false;
                }
                if (KeyBindings.cameraEmitRedstone.m_90859_()) {
                    CameraController.emitRedstone(cam);
                }
                if (KeyBindings.cameraActivateNightVision.m_90859_()) {
                    CameraController.giveNightVision(cam);
                }
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                double yRotChange = player.m_146908_() - player.f_108598_;
                double xRotChange = player.m_146909_() - player.f_108599_;
                if (yRotChange != 0.0 || xRotChange != 0.0) {
                    player.f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(player.m_146908_(), player.m_146909_(), player.m_20096_()));
                }
            }
        } else if (resetOverlaysAfterDismount) {
            resetOverlaysAfterDismount = false;
            OverlayToggleHandler.disable(ClientHandler.cameraOverlay);
            OverlayToggleHandler.enable(ClientHandler.hotbarBindOverlay);
            OverlayToggleHandler.enable(VanillaGuiOverlay.JUMP_BAR);
            OverlayToggleHandler.enable(VanillaGuiOverlay.EXPERIENCE_BAR);
            OverlayToggleHandler.enable(VanillaGuiOverlay.POTION_ICONS);
        }
    }

    private static void dismount() {
        SecurityCraft.channel.sendToServer((Object)new DismountCamera());
    }

    public static void moveViewUp(SecurityCamera cam) {
        float next = cam.m_146909_() - (float)CameraController.cameraSpeed() * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next > 40.0f) {
                cam.setRotation(cam.m_146908_(), next);
            }
        } else if (next > -25.0f) {
            cam.setRotation(cam.m_146908_(), next);
        }
    }

    public static void moveViewDown(SecurityCamera cam) {
        float next = cam.m_146909_() + (float)CameraController.cameraSpeed() * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next < 90.0f) {
                cam.setRotation(cam.m_146908_(), next);
            }
        } else if (next < 60.0f) {
            cam.setRotation(cam.m_146908_(), next);
        }
    }

    public static void moveViewHorizontally(SecurityCamera cam, float yRot, float next) {
        BlockState state = cam.f_19853_.m_8055_(cam.m_20183_());
        if (state.m_61138_((Property)SecurityCameraBlock.FACING)) {
            boolean shouldSetRotation;
            float checkNext = next;
            if (checkNext < 0.0f) {
                checkNext += 360.0f;
            }
            switch ((Direction)state.m_61143_((Property)SecurityCameraBlock.FACING)) {
                case NORTH: {
                    boolean bl;
                    if (checkNext > 90.0f && checkNext < 270.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case SOUTH: {
                    boolean bl;
                    if (checkNext > 270.0f || checkNext < 90.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case EAST: {
                    boolean bl;
                    if (checkNext > 180.0f && checkNext < 360.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case WEST: {
                    boolean bl;
                    if (checkNext > 0.0f && checkNext < 180.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case DOWN: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = shouldSetRotation = false;
                }
            }
            if (shouldSetRotation) {
                cam.m_146922_(next);
            }
        }
    }

    public static void zoomIn(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.m_91087_().f_91073_.m_245747_(cam.m_20183_(), SCSounds.CAMERAZOOMIN.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.zoomAmount = Math.max(cam.zoomAmount - 0.1f, 0.1f);
    }

    public static void zoomOut(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.m_91087_().f_91073_.m_245747_(cam.m_20183_(), SCSounds.CAMERAZOOMIN.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.zoomAmount = Math.min(cam.zoomAmount + 0.1f, 1.4f);
    }

    public static void emitRedstone(SecurityCamera cam) {
        if (cam.redstoneCooldown == 0) {
            cam.toggleRedstonePower();
            cam.redstoneCooldown = 30;
        }
    }

    public static void giveNightVision(SecurityCamera cam) {
        if (cam.toggleNightVisionCooldown == 0) {
            cam.toggleNightVision();
        }
    }

    public static ClientChunkCache.Storage getCameraStorage() {
        return cameraStorage;
    }

    public static void setCameraStorage(ClientChunkCache.Storage newStorage) {
        if (newStorage != null) {
            if (cameraStorage != null) {
                newStorage.f_104469_ = CameraController.cameraStorage.f_104469_;
                newStorage.f_104470_ = CameraController.cameraStorage.f_104470_;
                for (int i = 0; i < CameraController.cameraStorage.f_104466_.length(); ++i) {
                    LevelChunk chunk = (LevelChunk)CameraController.cameraStorage.f_104466_.get(i);
                    if (chunk == null) continue;
                    ChunkPos pos = chunk.m_7697_();
                    if (!newStorage.m_104500_(pos.f_45578_, pos.f_45579_)) continue;
                    newStorage.m_104484_(newStorage.m_104481_(pos.f_45578_, pos.f_45579_), chunk);
                }
            }
            cameraStorage = newStorage;
        }
    }

    public static void setHasLoadedChunks(boolean hasLoadedChunks) {
        chunksLoaded = hasLoadedChunks;
    }

    public static void setChunkLoadingDistance(int initialViewDistance) {
        chunkLoadingDistance = initialViewDistance;
    }

    public static boolean hasLoadedChunks() {
        return chunksLoaded;
    }

    public static int getChunkLoadingDistance() {
        return chunkLoadingDistance;
    }

    public static void setRenderPosition(Entity entity) {
        if (entity instanceof SecurityCamera) {
            SectionPos cameraPos = SectionPos.m_235861_((EntityAccess)entity);
            CameraController.cameraStorage.f_104469_ = cameraPos.m_123170_();
            CameraController.cameraStorage.f_104470_ = cameraPos.m_123222_();
        }
    }

    private static double cameraSpeed() {
        if (cameraSpeed < 0.0) {
            cameraSpeed = (Double)ConfigHandler.CLIENT.cameraSpeed.get();
        }
        return cameraSpeed;
    }

    static {
        resetOverlaysAfterDismount = false;
        chunksLoaded = false;
        chunkLoadingDistance = -1;
    }
}

