/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.CameraController;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.network.server.GiveNightVision;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.PacketDistributor;

public class SecurityCamera
extends Entity {
    public int screenshotSoundCooldown = 0;
    protected int redstoneCooldown = 0;
    protected int toggleNightVisionCooldown = 0;
    private boolean shouldProvideNightVision = false;
    protected float zoomAmount = 1.0f;
    protected boolean zooming = false;

    public SecurityCamera(EntityType<SecurityCamera> type, Level level) {
        super((EntityType)SCContent.SECURITY_CAMERA_ENTITY.get(), level);
        this.f_19794_ = true;
    }

    public SecurityCamera(Level level, BlockPos pos) {
        this((EntityType<SecurityCamera>)((EntityType)SCContent.SECURITY_CAMERA_ENTITY.get()), level);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SecurityCameraBlockEntity)) {
            this.m_146870_();
            return;
        }
        SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)blockEntity;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        if (cam.down) {
            y += 0.25;
        }
        this.m_6034_(x, y, z);
        this.setInitialPitchYaw();
    }

    public SecurityCamera(Level level, BlockPos pos, SecurityCamera oldCamera) {
        this(level, pos);
        oldCamera.m_146870_();
    }

    private void setInitialPitchYaw() {
        this.m_146926_(30.0f);
        Direction facing = (Direction)this.f_19853_.m_8055_(this.m_20183_()).m_61143_((Property)SecurityCameraBlock.FACING);
        if (facing == Direction.NORTH) {
            this.m_146922_(180.0f);
        } else if (facing == Direction.WEST) {
            this.m_146922_(90.0f);
        } else if (facing == Direction.SOUTH) {
            this.m_146922_(0.0f);
        } else if (facing == Direction.EAST) {
            this.m_146922_(270.0f);
        } else if (facing == Direction.DOWN) {
            this.m_146926_(75.0f);
        }
    }

    protected boolean m_6093_() {
        return false;
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            if (this.screenshotSoundCooldown > 0) {
                --this.screenshotSoundCooldown;
            }
            if (this.redstoneCooldown > 0) {
                --this.redstoneCooldown;
            }
            if (this.toggleNightVisionCooldown > 0) {
                --this.toggleNightVisionCooldown;
            }
            if (this.shouldProvideNightVision) {
                SecurityCraft.channel.sendToServer((Object)new GiveNightVision());
            }
        } else if (this.f_19853_.m_8055_(this.m_20183_()).m_60734_() != SCContent.SECURITY_CAMERA.get()) {
            this.m_146870_();
        }
    }

    public void toggleRedstonePower() {
        BlockPos pos = this.m_20183_();
        if (((IModuleInventory)this.f_19853_.m_7702_(pos)).isModuleEnabled(ModuleType.REDSTONE)) {
            SecurityCraft.channel.sendToServer((Object)new SetCameraPowered(pos, (Boolean)this.f_19853_.m_8055_(pos).m_61143_((Property)SecurityCameraBlock.POWERED) == false));
        }
    }

    public void toggleNightVision() {
        this.toggleNightVisionCooldown = 30;
        this.shouldProvideNightVision = !this.shouldProvideNightVision;
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCameraDown() {
        BlockEntity blockEntity = this.f_19853_.m_7702_(this.m_20183_());
        if (!(blockEntity instanceof SecurityCameraBlockEntity)) return false;
        SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)blockEntity;
        if (!cam.down) return false;
        return true;
    }

    public void setRotation(float yaw, float pitch) {
        this.m_19915_(yaw, pitch);
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
        this.discardCamera();
    }

    public void stopViewing(ServerPlayer player) {
        if (!this.f_19853_.f_46443_) {
            this.m_146870_();
            player.f_8926_ = player;
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SetCameraView((Entity)player));
        }
    }

    @Deprecated
    public void discardCamera() {
        if (!this.f_19853_.f_46443_) {
            BlockEntity blockEntity = this.f_19853_.m_7702_(this.m_20183_());
            if (blockEntity instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity camBe = (SecurityCameraBlockEntity)blockEntity;
                camBe.stopViewing();
            }
            SectionPos chunkPos = SectionPos.m_123199_((BlockPos)this.m_20183_());
            int chunkLoadingDistance = CameraController.getChunkLoadingDistance() <= 0 ? this.f_19853_.m_7654_().m_6846_().m_11312_() : CameraController.getChunkLoadingDistance();
            for (int x = chunkPos.m_123341_() - chunkLoadingDistance; x <= chunkPos.m_123341_() + chunkLoadingDistance; ++x) {
                for (int z = chunkPos.m_123343_() - chunkLoadingDistance; z <= chunkPos.m_123343_() + chunkLoadingDistance; ++z) {
                    ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_19853_), (String)"securitycraft", (Entity)this, (int)x, (int)z, (boolean)false, (boolean)false);
                }
            }
        }
    }

    protected void m_8097_() {
    }

    public void m_7380_(CompoundTag tag) {
    }

    public void m_7378_(CompoundTag tag) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_142389_() {
        return true;
    }
}

