/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.CageTrapBlock;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.SpecialDoorBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedDoorBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.util.TriConsumer;

public class UniversalBlockRemoverItem
extends Item {
    public UniversalBlockRemoverItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        BlockEntity be = level.m_7702_(pos);
        Player player = ctx.m_43723_();
        if (be != null && UniversalBlockRemoverItem.isOwnableBlock(block, be)) {
            if (!((IOwnable)be).isOwnedBy(player)) {
                DisguisableBlock db;
                Block block2;
                if (!(block instanceof IBlockMine || (block2 = be.m_58900_().m_60734_()) instanceof DisguisableBlock && !(((BlockItem)(db = (DisguisableBlock)block2).getDisguisedStack((BlockGetter)level, pos).m_41720_()).m_40614_() instanceof DisguisableBlock))) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_BLOCK_REMOVER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(((IOwnable)be).getOwner().getName())), ChatFormatting.RED);
                }
                return InteractionResult.FAIL;
            }
            if (be instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)be;
                inv.dropAllModules();
            }
            if (block == SCContent.LASER_BLOCK.get()) {
                LinkableBlockEntity laser = (LinkableBlockEntity)level.m_7702_(pos);
                for (ItemStack module : laser.getInventory()) {
                    if (module.m_41619_()) continue;
                    laser.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)module.m_41720_()).getModuleType(), false), laser);
                }
                if (!level.f_46443_) {
                    level.m_46961_(pos, true);
                    LaserBlock.destroyAdjacentLasers((LevelAccessor)level, pos);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
                }
            } else if (block == SCContent.CAGE_TRAP.get() && ((Boolean)level.m_8055_(pos).m_61143_((Property)CageTrapBlock.DEACTIVATED)).booleanValue()) {
                BlockPos originalPos = pos;
                BlockPos middlePos = originalPos.m_6630_(4);
                if (!level.f_46443_) {
                    new CageTrapBlock.BlockModifier(level, new BlockPos.MutableBlockPos().m_122190_((Vec3i)originalPos), ((IOwnable)be).getOwner()).loop((TriConsumer<Level, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                        Block b;
                        IOwnable ownable;
                        BlockEntity te = w.m_7702_((BlockPos)p);
                        if (te instanceof IOwnable && o.owns(ownable = (IOwnable)te) && ((b = w.m_8055_((BlockPos)p).m_60734_()) == SCContent.REINFORCED_IRON_BARS.get() || p.equals((Object)middlePos) && b == SCContent.HORIZONTAL_REINFORCED_IRON_BARS.get())) {
                            w.m_46961_((BlockPos)p, false);
                        }
                    }));
                    level.m_46961_(originalPos, true);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
                }
            } else {
                InventoryScannerBlockEntity inventoryScanner;
                if ((block instanceof ReinforcedDoorBlock || block instanceof SpecialDoorBlock) && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
                    pos = pos.m_7495_();
                }
                if (block == SCContent.INVENTORY_SCANNER.get() && (inventoryScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos)) != null) {
                    inventoryScanner.getInventory().clear();
                }
                if (!level.f_46443_) {
                    level.m_46961_(pos, true);
                    block.m_6786_((LevelAccessor)level, pos, state);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean isOwnableBlock(Block block, BlockEntity be) {
        return be instanceof OwnableBlockEntity || be instanceof IOwnable || block instanceof OwnableBlock;
    }
}

