/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class LimitedUseKeycardRecipe
extends CustomRecipe {
    public LimitedUseKeycardRecipe(ResourceLocation id, CraftingBookCategory craftingBookCategory) {
        super(id, craftingBookCategory);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        boolean hasNormalKeycard = false;
        boolean hasLimitedUseKeycard = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Item item = stack.m_41720_();
            if (item instanceof KeycardItem) {
                if (item != SCContent.LIMITED_USE_KEYCARD.get()) {
                    if (hasNormalKeycard || stack.m_41784_().m_128471_("limited")) {
                        return false;
                    }
                    hasNormalKeycard = true;
                    continue;
                }
                if (hasLimitedUseKeycard) {
                    return false;
                }
                hasLimitedUseKeycard = true;
                continue;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return hasNormalKeycard && hasLimitedUseKeycard;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack keycard = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof KeycardItem) || item == SCContent.LIMITED_USE_KEYCARD.get()) continue;
            keycard = stack.m_41777_();
            break;
        }
        if (keycard.m_41619_()) {
            return ItemStack.f_41583_;
        }
        CompoundTag tag = keycard.m_41784_();
        tag.m_128379_("limited", true);
        tag.m_128405_("uses", 0);
        keycard.m_41764_(2);
        return keycard;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SCContent.LIMITED_USE_KEYCARD_RECIPE_SERIALIZER.get();
    }
}

