/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;

public class SetCameraPowered {
    private BlockPos pos;
    private boolean powered;

    public SetCameraPowered() {
    }

    public SetCameraPowered(BlockPos pos, boolean powered) {
        this.pos = pos;
        this.powered = powered;
    }

    public static void encode(SetCameraPowered message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeBoolean(message.powered);
    }

    public static SetCameraPowered decode(FriendlyByteBuf buf) {
        SetCameraPowered message = new SetCameraPowered();
        message.pos = buf.m_130135_();
        message.powered = buf.readBoolean();
        return message;
    }

    public static void onMessage(SetCameraPowered message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IModuleInventory moduleInv;
            IOwnable ownable;
            BlockPos pos = message.pos;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level level = player.f_19853_;
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof IOwnable && (ownable = (IOwnable)be).isOwnedBy((Player)player) || be instanceof IModuleInventory && (moduleInv = (IModuleInventory)be).isAllowed((Entity)player)) {
                BlockState state = level.m_8055_(pos);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(message.powered)));
                level.m_46672_(pos.m_5484_((Direction)state.m_61143_((Property)SecurityCameraBlock.FACING), -1), state.m_60734_());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

