/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class DisplayCaseRenderer
implements BlockEntityRenderer<DisplayCaseBlockEntity> {
    private final ResourceLocation texture = new ResourceLocation("securitycraft", "textures/entity/display_case.png");
    private final ResourceLocation glowTexture = new ResourceLocation("securitycraft", "textures/entity/glow_display_case.png");
    private final ModelPart main;
    private final ModelPart door;
    private final boolean glowing;

    public DisplayCaseRenderer(BlockEntityRendererProvider.Context ctx, boolean glowing) {
        ModelPart model = ctx.m_173582_(glowing ? ClientHandler.GLOW_DISPLAY_CASE_LOCATION : ClientHandler.DISPLAY_CASE_LOCATION);
        this.main = model.m_171324_("main");
        this.door = model.m_171324_("door");
        this.glowing = glowing;
    }

    public static LayerDefinition createModelLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("main", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171481_(-6.0f, -3.0f, -8.0f, 12.0f, 1.0f, 5.0f).m_171514_(36, 0).m_171481_(-6.0f, -13.0f, -8.0f, 1.0f, 10.0f, 5.0f).m_171514_(13, 4).m_171481_(-5.0f, -13.0f, -8.0f, 10.0f, 10.0f, 1.0f).m_171514_(0, 0).m_171481_(5.0f, -13.0f, -8.0f, 1.0f, 10.0f, 5.0f).m_171514_(0, 16).m_171481_(-6.0f, -14.0f, -8.0f, 12.0f, 1.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_("door", CubeListBuilder.m_171558_().m_171514_(5, 31).m_171481_(1.0f, -5.0f, 0.0f, 10.0f, 10.0f, 1.0f).m_171514_(0, 31).m_171481_(11.0f, -5.0f, 0.0f, 1.0f, 10.0f, 1.0f).m_171514_(28, 31).m_171481_(0.0f, -5.0f, 0.0f, 1.0f, 10.0f, 1.0f).m_171514_(0, 43).m_171481_(0.0f, -6.0f, 0.0f, 12.0f, 1.0f, 1.0f).m_171514_(0, 46).m_171481_(0.0f, 5.0f, 0.0f, 12.0f, 1.0f, 1.0f).m_171514_(27, 43).m_171481_(11.0f, -1.5f, 1.0f, 1.0f, 3.0f, 1.0f), PartPose.m_171419_((float)-6.0f, (float)16.0f, (float)-3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)48, (int)48);
    }

    public void render(DisplayCaseBlockEntity be, float partialTick, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState state = be.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)DisplayCaseBlock.FACING);
        float rotation = facing.m_122435_();
        ItemStack displayedStack = be.getDisplayedStack();
        int light = this.glowing ? 15728850 : packedLight;
        this.door.f_104204_ = -(be.getOpenness(partialTick) * 1.5707964f);
        pose.m_85836_();
        pose.m_85837_(0.5, 0.5, 0.5);
        if (!displayedStack.m_41619_()) {
            double insertionAmount = 0.40625;
            pose.m_85836_();
            switch ((AttachFace)state.m_61143_(DisplayCaseBlock.ATTACH_FACE)) {
                case CEILING: {
                    pose.m_85837_(0.0, insertionAmount, 0.0);
                    pose.m_252781_(Axis.f_252436_.m_252977_(-rotation + 180.0f));
                    pose.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    break;
                }
                case FLOOR: {
                    pose.m_85837_(0.0, -insertionAmount, 0.0);
                    pose.m_252781_(Axis.f_252436_.m_252977_(-rotation + 180.0f));
                    pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    break;
                }
                case WALL: {
                    pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    pose.m_252781_(Axis.f_252436_.m_252977_(-rotation));
                    pose.m_85837_(0.0, 0.0, insertionAmount);
                }
            }
            pose.m_85841_(0.5f, 0.5f, 0.5f);
            Minecraft.m_91087_().m_91291_().m_174269_(displayedStack, ItemTransforms.TransformType.FIXED, light, OverlayTexture.f_118083_, pose, buffer, 0);
            pose.m_85849_();
        }
        pose.m_252781_(Axis.f_252436_.m_252977_(-rotation));
        switch ((AttachFace)state.m_61143_(DisplayCaseBlock.ATTACH_FACE)) {
            case CEILING: {
                pose.m_85837_(0.0, 0.0, 1.0);
                pose.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                break;
            }
            case FLOOR: {
                pose.m_85837_(0.0, 0.0, -1.0);
                pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case WALL: {
                pose.m_85837_(0.0, 1.0, 0.0);
                pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            }
        }
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)(this.glowing ? this.glowTexture : this.texture)));
        pose.m_85841_(-1.0f, 1.0f, -1.0f);
        this.main.m_104301_(pose, consumer, light, packedOverlay);
        this.door.m_104301_(pose, consumer, light, packedOverlay);
        pose.m_85849_();
    }
}

