/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.inventory.BlockPocketManagerMenu;
import net.geforcemods.securitycraft.network.server.SyncBlockPocketManager;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.geforcemods.securitycraft.screen.components.ColorChooser;
import net.geforcemods.securitycraft.screen.components.ColorChooserButton;
import net.geforcemods.securitycraft.screen.components.StackHoverChecker;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.ToggleComponentButton;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public class BlockPocketManagerScreen
extends AbstractContainerScreen<BlockPocketManagerMenu>
implements IHasExtraAreas {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/block_pocket_manager.png");
    private static final ResourceLocation TEXTURE_STORAGE = new ResourceLocation("securitycraft:textures/gui/container/block_pocket_manager_storage.png");
    private static final ItemStack BLOCK_POCKET_WALL = new ItemStack((ItemLike)SCContent.BLOCK_POCKET_WALL.get());
    private static final ItemStack REINFORCED_CHISELED_CRYSTAL_QUARTZ = new ItemStack((ItemLike)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get());
    private static final ItemStack REINFORCED_CRYSTAL_QUARTZ_PILLAR = new ItemStack((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get());
    private final Component blockPocketManager = Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).m_7705_(), new Object[0]);
    private final Component youNeed = Utils.localize("gui.securitycraft:blockPocketManager.youNeed", new Object[0]);
    private final boolean storage;
    private final boolean isOwner;
    private final int[] materialCounts = new int[3];
    public BlockPocketManagerBlockEntity be;
    private int size = 5;
    private final int[] allowedSizes = new int[]{5, 9, 13, 17, 21, 25};
    private Button toggleButton;
    private Button sizeButton;
    private Button assembleButton;
    private Button outlineButton;
    private CallbackSlider offsetSlider;
    private StackHoverChecker[] hoverCheckers = new StackHoverChecker[3];
    private TextHoverChecker assembleHoverChecker;
    private TextHoverChecker colorChooserButtonHoverChecker;
    private ColorChooser colorChooser;
    private int wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
    private int pillarsNeededOverall = (this.size - 2) * 12 - 1;
    private final int chiseledNeededOverall = 8;
    private int wallsStillNeeded;
    private int pillarsStillNeeded;
    private int chiseledStillNeeded;
    private final int previousColor;

    public BlockPocketManagerScreen(BlockPocketManagerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.be = menu.be;
        this.size = this.be.size;
        this.isOwner = menu.isOwner;
        this.storage = menu.storage;
        if (this.storage) {
            this.f_97726_ = 256;
        }
        this.f_97727_ = !this.storage ? 194 : 240;
        this.previousColor = this.be.getColor();
    }

    public void m_7856_() {
        int[] nArray;
        super.m_7856_();
        int guiWidth = this.storage ? 123 : this.f_97726_;
        int widgetWidth = this.storage ? 110 : 120;
        int widgetOffset = widgetWidth / 2;
        if (this.storage) {
            int[] nArray2 = new int[5];
            nArray2[0] = -76;
            nArray2[1] = -100;
            nArray2[2] = -52;
            nArray2[3] = -28;
            nArray = nArray2;
            nArray2[4] = -4;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = -40;
            nArray3[1] = -70;
            nArray3[2] = 23;
            nArray3[3] = 47;
            nArray = nArray3;
            nArray3[4] = 71;
        }
        int[] yOffset = nArray;
        int outlineY = this.f_97736_ + this.f_97727_ / 2 + yOffset[2];
        int colorChooserButtonX = this.f_97735_ + guiWidth / 2 - widgetOffset + (this.storage ? 0 : widgetWidth + 3);
        int outlineButtonX = colorChooserButtonX + (this.storage ? 23 : -widgetWidth - 3);
        int outlineButtonWidth = widgetWidth - (this.storage ? 23 : 0);
        int colorChooserX = colorChooserButtonX + (this.storage ? -145 : 20);
        this.toggleButton = new ExtendedButton(this.f_97735_ + guiWidth / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[0], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager." + (!this.be.enabled ? "activate" : "deactivate"), new Object[0]), this::toggleButtonClicked);
        this.m_142416_((GuiEventListener)this.toggleButton);
        this.sizeButton = new ToggleComponentButton(this.f_97735_ + guiWidth / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[1], widgetWidth, 20, this::updateSizeButtonText, ArrayUtils.indexOf((int[])this.allowedSizes, (int)this.size), this.allowedSizes.length, this::sizeButtonClicked);
        this.m_142416_((GuiEventListener)this.sizeButton);
        this.outlineButton = new ExtendedButton(outlineButtonX, outlineY, outlineButtonWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.be.showOutline ? "show" : "hide"), new Object[0]), this::outlineButtonClicked);
        this.m_142416_((GuiEventListener)this.outlineButton);
        this.assembleButton = new ExtendedButton(this.f_97735_ + guiWidth / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[3], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager.assemble", new Object[0]), this::assembleButtonClicked);
        this.m_142416_((GuiEventListener)this.assembleButton);
        this.offsetSlider = new CallbackSlider(this.f_97735_ + guiWidth / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[4], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.offset", ""), (Component)Component.m_237119_(), (-this.size + 2) / 2, (this.size - 2) / 2, this.be.autoBuildOffset, true, this::offsetSliderReleased);
        this.m_142416_((GuiEventListener)this.offsetSlider);
        this.colorChooser = new ColorChooser((Component)Component.m_237119_(), colorChooserX, outlineY, this.be.getColor()){

            @Override
            public void onColorChange() {
                BlockPocketManagerScreen.this.be.setColor(this.getRGBColor());
            }
        };
        this.m_142416_(this.colorChooser);
        this.colorChooser.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        ColorChooserButton colorChooserButton = new ColorChooserButton(colorChooserButtonX, outlineY, 20, 20, this.colorChooser);
        this.m_142416_((GuiEventListener)colorChooserButton);
        if (!this.be.isOwnedBy((Player)Minecraft.m_91087_().f_91074_)) {
            colorChooserButton.f_93623_ = false;
            this.offsetSlider.f_93623_ = false;
            this.outlineButton.f_93623_ = false;
            this.assembleButton.f_93623_ = false;
            this.toggleButton.f_93623_ = false;
            this.sizeButton.f_93623_ = false;
        } else {
            this.updateMaterialInformation(true);
            this.offsetSlider.f_93623_ = !this.be.enabled;
            this.sizeButton.f_93623_ = this.offsetSlider.f_93623_;
        }
        if (!this.storage) {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.f_97736_ + 93, this.f_97736_ + 113, this.f_97735_ + 23, this.f_97735_ + 43);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.f_97736_ + 93, this.f_97736_ + 113, this.f_97735_ + 75, this.f_97735_ + 95);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.f_97736_ + 93, this.f_97736_ + 113, this.f_97735_ + 128, this.f_97735_ + 148);
        } else {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.f_97736_ + this.f_97727_ - 73, this.f_97736_ + this.f_97727_ - 54, this.f_97735_ + 174, this.f_97735_ + 191);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.f_97736_ + this.f_97727_ - 50, this.f_97736_ + this.f_97727_ - 31, this.f_97735_ + 174, this.f_97735_ + 191);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.f_97736_ + this.f_97727_ - 27, this.f_97736_ + this.f_97727_ - 9, this.f_97735_ + 174, this.f_97735_ + 191);
        }
        this.assembleHoverChecker = new TextHoverChecker((AbstractWidget)this.assembleButton, Arrays.asList(Utils.localize("gui.securitycraft:blockPocketManager.needStorageModule", new Object[0]), Utils.localize("messages.securitycraft:blockpocket.notEnoughItems", new Object[0])));
        this.colorChooserButtonHoverChecker = new TextHoverChecker((AbstractWidget)colorChooserButton, (Component)Utils.localize("gui.securitycraft:choose_outline_color_tooltip", new Object[0]));
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(pose, this.blockPocketManager, (float)((this.storage ? 123 : this.f_97726_) / 2 - this.f_96547_.m_92852_((FormattedText)this.blockPocketManager) / 2), 6.0f, 0x404040);
        if (this.storage) {
            this.f_96547_.m_92889_(pose, this.f_169604_, 8.0f, (float)(this.f_97727_ - 94), 0x404040);
            this.m_7025_(pose, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (!this.be.enabled && this.isOwner) {
            if (!this.storage) {
                this.f_96547_.m_92889_(pose, this.youNeed, (float)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.youNeed) / 2), 83.0f, 0x404040);
                this.f_96547_.m_92883_(pose, "" + this.wallsNeededOverall, 42.0f, 100.0f, 0x404040);
                this.f_96541_.m_91291_().m_115203_(BLOCK_POCKET_WALL, 25, 96);
                this.f_96547_.m_92883_(pose, "" + this.pillarsNeededOverall, 94.0f, 100.0f, 0x404040);
                this.f_96541_.m_91291_().m_115203_(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 77, 96);
                this.f_96547_.m_92883_(pose, "8", 147.0f, 100.0f, 0x404040);
                this.f_96541_.m_91291_().m_115203_(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 130, 96);
            } else {
                this.f_96547_.m_92889_(pose, this.youNeed, (float)(212 - this.f_96547_.m_92852_((FormattedText)this.youNeed) / 2), (float)(this.f_97727_ - 83), 0x404040);
                this.f_96547_.m_92883_(pose, "" + Math.max(0, this.wallsStillNeeded), 192.0f, (float)(this.f_97727_ - 66), 0x404040);
                this.f_96541_.m_91291_().m_115203_(BLOCK_POCKET_WALL, 175, this.f_97727_ - 70);
                this.f_96547_.m_92883_(pose, "" + Math.max(0, this.pillarsStillNeeded), 192.0f, (float)(this.f_97727_ - 44), 0x404040);
                this.f_96541_.m_91291_().m_115203_(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 175, this.f_97727_ - 48);
                this.f_96547_.m_92883_(pose, "" + Math.max(0, this.chiseledStillNeeded), 192.0f, (float)(this.f_97727_ - 22), 0x404040);
                this.f_96541_.m_91291_().m_115203_(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 175, this.f_97727_ - 26);
            }
        }
    }

    public void m_86412_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(pose, mouseX, mouseY, partialTicks);
        if (!this.be.enabled && this.isOwner) {
            for (StackHoverChecker shc : this.hoverCheckers) {
                if (!shc.checkHover(mouseX, mouseY)) continue;
                this.m_6057_(pose, shc.getStack(), mouseX, mouseY);
                break;
            }
            if (!this.assembleButton.f_93623_ && this.assembleHoverChecker.checkHover(mouseX, mouseY)) {
                if (!this.storage) {
                    this.m_96597_(pose, this.assembleHoverChecker.getLines().subList(0, 1), mouseX, mouseY);
                } else {
                    this.m_96597_(pose, this.assembleHoverChecker.getLines().subList(1, 2), mouseX, mouseY);
                }
            }
            if (this.colorChooserButtonHoverChecker.checkHover(mouseX, mouseY)) {
                this.m_96602_(pose, this.colorChooserButtonHoverChecker.getName(), mouseX, mouseY);
            }
        }
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)(this.storage ? TEXTURE_STORAGE : TEXTURE));
        this.m_93228_(pose, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_181908_() {
        if (this.colorChooser != null) {
            this.colorChooser.m_86600_();
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.colorChooser != null) {
            this.colorChooser.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return this.m_7222_() != null && this.m_7282_() && button == 0 && this.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY) || super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.colorChooser != null) {
            this.colorChooser.m_7933_(keyCode, scanCode, modifiers);
        }
        if (!this.colorChooser.rgbHexBox.m_93696_()) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        return true;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.colorChooser != null && this.colorChooser.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.m_6597_(slot, slotId, mouseButton, type);
        this.updateMaterialInformation(true);
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        if (this.colorChooser != null) {
            return this.colorChooser.getGuiExtraAreas();
        }
        return List.of();
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.previousColor != this.be.getColor()) {
            this.sync();
        }
    }

    private void updateMaterialInformation(boolean recalculateStoredStacks) {
        if (recalculateStoredStacks) {
            this.materialCounts[2] = 0;
            this.materialCounts[1] = 0;
            this.materialCounts[0] = 0;
            this.be.getStorageHandler().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    Item patt13491$temp = stack.m_41720_();
                    if (!(patt13491$temp instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)patt13491$temp;
                    Block block = blockItem.m_40614_();
                    if (block == SCContent.BLOCK_POCKET_WALL.get()) {
                        this.materialCounts[0] = this.materialCounts[0] + stack.m_41613_();
                        continue;
                    }
                    if (block == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                        this.materialCounts[1] = this.materialCounts[1] + stack.m_41613_();
                        continue;
                    }
                    if (block != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()) continue;
                    this.materialCounts[2] = this.materialCounts[2] + stack.m_41613_();
                }
            });
        }
        this.wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
        this.pillarsNeededOverall = (this.size - 2) * 12 - 1;
        this.wallsStillNeeded = this.wallsNeededOverall - this.materialCounts[0];
        this.pillarsStillNeeded = this.pillarsNeededOverall - this.materialCounts[1];
        this.chiseledStillNeeded = 8 - this.materialCounts[2];
        this.assembleButton.f_93623_ = this.isOwner && (this.f_96541_.f_91074_.m_7500_() || !this.be.enabled && this.storage && this.wallsStillNeeded <= 0 && this.pillarsStillNeeded <= 0 && this.chiseledStillNeeded <= 0);
    }

    public void toggleButtonClicked(Button button) {
        if (this.be.enabled) {
            this.be.disableMultiblock();
        } else {
            this.be.size = this.size;
            MutableComponent feedback = this.be.enableMultiblock();
            if (feedback != null) {
                PlayerUtils.sendMessageToPlayer((Player)Minecraft.m_91087_().f_91074_, Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).m_7705_(), new Object[0]), feedback, ChatFormatting.DARK_AQUA, true);
            }
        }
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    public void sizeButtonClicked(Button button) {
        this.size = this.allowedSizes[((ToggleComponentButton)button).getCurrentIndex()];
        int newMin = (-this.size + 2) / 2;
        int newMax = (this.size - 2) / 2;
        int newOffset = this.be.autoBuildOffset > 0 ? Math.min(this.be.autoBuildOffset, newMax) : Math.max(this.be.autoBuildOffset, newMin);
        this.updateMaterialInformation(false);
        this.be.size = this.size;
        this.offsetSlider.setMinValue(newMin);
        this.offsetSlider.setMaxValue(newMax);
        this.be.autoBuildOffset = newOffset;
        this.offsetSlider.m_93611_(newOffset);
        this.sync();
        ((ToggleComponentButton)button).onValueChange();
    }

    public Component updateSizeButtonText(int index) {
        return Utils.localize("gui.securitycraft:blockPocketManager.size", this.size, this.size, this.size);
    }

    public void assembleButtonClicked(Button button) {
        this.be.size = this.size;
        MutableComponent feedback = this.be.autoAssembleMultiblock();
        if (feedback != null) {
            PlayerUtils.sendMessageToPlayer((Player)Minecraft.m_91087_().f_91074_, Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).m_7705_(), new Object[0]), feedback, ChatFormatting.DARK_AQUA, true);
        }
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    public void outlineButtonClicked(Button button) {
        this.be.toggleOutline();
        this.outlineButton.m_93666_((Component)Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.be.showOutline ? "show" : "hide"), new Object[0]));
        this.sync();
    }

    public void offsetSliderReleased(CallbackSlider slider) {
        this.be.autoBuildOffset = slider.getValueInt();
        this.sync();
    }

    private void sync() {
        SecurityCraft.channel.send(PacketDistributor.SERVER.noArg(), (Object)new SyncBlockPocketManager(this.be.m_58899_(), this.be.size, this.be.showOutline, this.be.autoBuildOffset, this.be.getColor()));
    }
}

