/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientDisplay
implements Renderable {
    private static final int DISPLAY_LENGTH = 20;
    private final int x;
    private final int y;
    private ItemStack[] stacks;
    private int currentRenderingStack = 0;
    private float ticksToChange = 20.0f;

    public IngredientDisplay(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void m_86412_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        if (this.stacks == null || this.stacks.length == 0) {
            return;
        }
        Minecraft.m_91087_().m_91291_().m_115203_(this.stacks[this.currentRenderingStack], this.x, this.y);
        if (!Screen.m_96638_()) {
            this.ticksToChange -= partialTick;
            if (this.ticksToChange <= 0.0f) {
                this.changeRenderingStack(1.0);
                this.ticksToChange = 20.0f;
            }
        }
    }

    public void setIngredient(Ingredient ingredient) {
        this.stacks = ingredient.m_43908_();
        this.currentRenderingStack = 0;
        this.ticksToChange = 20.0f;
    }

    public ItemStack getCurrentStack() {
        return this.currentRenderingStack >= 0 && this.currentRenderingStack < this.stacks.length && this.stacks.length != 0 ? this.stacks[this.currentRenderingStack] : ItemStack.f_41583_;
    }

    public void changeRenderingStack(double direction) {
        this.currentRenderingStack = (int)((double)this.currentRenderingStack + Math.signum(direction));
        if (this.currentRenderingStack < 0) {
            this.currentRenderingStack = this.stacks.length - 1;
        } else if (this.currentRenderingStack >= this.stacks.length) {
            this.currentRenderingStack = 0;
        }
    }
}

