/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.client.model.interactive.FramedPressurePlateModel;

public class FramedMarkedPressurePlateModel
extends FramedPressurePlateModel {
    public static final ResourceLocation STONE_FRAME_LOCATION = new ResourceLocation("framedblocks", "block/stone_plate_frame");
    public static final ResourceLocation STONE_FRAME_DOWN_LOCATION = new ResourceLocation("framedblocks", "block/stone_plate_down_frame");
    public static final ResourceLocation OBSIDIAN_FRAME_LOCATION = new ResourceLocation("framedblocks", "block/obsidian_plate_frame");
    public static final ResourceLocation OBSIDIAN_FRAME_DOWN_LOCATION = new ResourceLocation("framedblocks", "block/obsidian_plate_down_frame");
    public static final ResourceLocation GOLD_FRAME_LOCATION = new ResourceLocation("framedblocks", "block/gold_plate_frame");
    public static final ResourceLocation GOLD_FRAME_DOWN_LOCATION = new ResourceLocation("framedblocks", "block/gold_plate_down_frame");
    public static final ResourceLocation IRON_FRAME_LOCATION = new ResourceLocation("framedblocks", "block/iron_plate_frame");
    public static final ResourceLocation IRON_FRAME_DOWN_LOCATION = new ResourceLocation("framedblocks", "block/iron_plate_down_frame");
    private static final Map<ResourceLocation, BakedModel> FRAME_MODELS = new HashMap<ResourceLocation, BakedModel>();
    private final BakedModel frameModel;

    private FramedMarkedPressurePlateModel(BlockState state, BakedModel baseModel, ResourceLocation frameLocation, boolean powered) {
        super(state, baseModel, powered);
        this.frameModel = FRAME_MODELS.get(frameLocation);
    }

    @Override
    protected ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        FramedBlockData fbData = (FramedBlockData)extraData.get(FramedBlockData.PROPERTY);
        if (fbData != null && !fbData.getCamoState().m_60795_()) {
            return ModelUtils.CUTOUT;
        }
        return ChunkRenderTypeSet.none();
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, RandomSource rand, ModelData data, RenderType layer) {
        FramedBlockData fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
        if (fbData == null || fbData.getCamoState().m_60795_()) {
            return;
        }
        quadMap.get(null).addAll(this.frameModel.getQuads(state, null, rand, data, layer));
        for (Direction side : Direction.values()) {
            quadMap.get(side).addAll(this.frameModel.getQuads(state, side, rand, data, layer));
        }
    }

    @Override
    protected boolean forceUngeneratedBaseModel() {
        return true;
    }

    public static FramedMarkedPressurePlateModel stone(BlockState state, BakedModel baseModel) {
        boolean powered = (Boolean)state.m_61143_((Property)PressurePlateBlock.f_55249_);
        ResourceLocation frame = powered ? STONE_FRAME_DOWN_LOCATION : STONE_FRAME_LOCATION;
        return new FramedMarkedPressurePlateModel(state, baseModel, frame, powered);
    }

    public static FramedMarkedPressurePlateModel obsidian(BlockState state, BakedModel baseModel) {
        boolean powered = (Boolean)state.m_61143_((Property)PressurePlateBlock.f_55249_);
        ResourceLocation frame = powered ? OBSIDIAN_FRAME_DOWN_LOCATION : OBSIDIAN_FRAME_LOCATION;
        return new FramedMarkedPressurePlateModel(state, baseModel, frame, powered);
    }

    public static FramedMarkedPressurePlateModel gold(BlockState state, BakedModel baseModel) {
        boolean powered = (Integer)state.m_61143_((Property)WeightedPressurePlateBlock.f_58198_) > 0;
        ResourceLocation frame = powered ? GOLD_FRAME_DOWN_LOCATION : GOLD_FRAME_LOCATION;
        return new FramedMarkedPressurePlateModel(state, baseModel, frame, powered);
    }

    public static FramedMarkedPressurePlateModel iron(BlockState state, BakedModel baseModel) {
        boolean powered = (Integer)state.m_61143_((Property)WeightedPressurePlateBlock.f_58198_) > 0;
        ResourceLocation frame = powered ? IRON_FRAME_DOWN_LOCATION : IRON_FRAME_LOCATION;
        return new FramedMarkedPressurePlateModel(state, baseModel, frame, powered);
    }

    public static void registerFrameModels(ModelEvent.RegisterAdditional event) {
        event.register(STONE_FRAME_LOCATION);
        event.register(STONE_FRAME_DOWN_LOCATION);
        event.register(OBSIDIAN_FRAME_LOCATION);
        event.register(OBSIDIAN_FRAME_DOWN_LOCATION);
        event.register(GOLD_FRAME_LOCATION);
        event.register(GOLD_FRAME_DOWN_LOCATION);
        event.register(IRON_FRAME_LOCATION);
        event.register(IRON_FRAME_DOWN_LOCATION);
    }

    public static void cacheFrameModels(Map<ResourceLocation, BakedModel> registry) {
        FRAME_MODELS.clear();
        FRAME_MODELS.put(STONE_FRAME_LOCATION, registry.get(STONE_FRAME_LOCATION));
        FRAME_MODELS.put(STONE_FRAME_DOWN_LOCATION, registry.get(STONE_FRAME_DOWN_LOCATION));
        FRAME_MODELS.put(OBSIDIAN_FRAME_LOCATION, registry.get(OBSIDIAN_FRAME_LOCATION));
        FRAME_MODELS.put(OBSIDIAN_FRAME_DOWN_LOCATION, registry.get(OBSIDIAN_FRAME_DOWN_LOCATION));
        FRAME_MODELS.put(GOLD_FRAME_LOCATION, registry.get(GOLD_FRAME_LOCATION));
        FRAME_MODELS.put(GOLD_FRAME_DOWN_LOCATION, registry.get(GOLD_FRAME_DOWN_LOCATION));
        FRAME_MODELS.put(IRON_FRAME_LOCATION, registry.get(IRON_FRAME_LOCATION));
        FRAME_MODELS.put(IRON_FRAME_DOWN_LOCATION, registry.get(IRON_FRAME_DOWN_LOCATION));
    }
}

