/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;

public class FramedLatticeModel
extends FramedBlockModel {
    private static final float MIN_COORD = 0.375f;
    private static final float MAX_COORD = 0.625f;
    private final boolean xAxis;
    private final boolean yAxis;
    private final boolean zAxis;

    public FramedLatticeModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.xAxis = (Boolean)state.m_61143_((Property)FramedProperties.X_AXIS);
        this.yAxis = (Boolean)state.m_61143_((Property)FramedProperties.Y_AXIS);
        this.zAxis = (Boolean)state.m_61143_((Property)FramedProperties.Z_AXIS);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quadDir)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f)).applyIf(Modifiers.setPosition(0.625f), !this.yAxis).export(quadMap.get(this.yAxis ? quadDir : null));
            if (this.xAxis) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.0f, 0.375f, 0.375f, 0.625f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.625f, 0.375f, 1.0f, 0.625f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
            }
            if (this.zAxis) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.375f, 0.0f, 0.625f, 0.375f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.375f, 0.625f, 0.625f, 1.0f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
            }
        } else if (Utils.isX(quadDir)) {
            FramedLatticeModel.createHorizontalStrutSideQuads(quadMap, quad, this.xAxis, this.zAxis);
        } else if (Utils.isZ(quadDir)) {
            FramedLatticeModel.createHorizontalStrutSideQuads(quadMap, quad, this.zAxis, this.xAxis);
        }
        if (!Utils.isY(quadDir) && this.yAxis) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.375f, 0.0f, 0.625f, 0.375f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.375f, 0.625f, 0.625f, 1.0f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
        }
    }

    private static void createHorizontalStrutSideQuads(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, boolean frontAxis, boolean sideAxis) {
        QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.375f, 0.375f, 0.625f, 0.625f)).applyIf(Modifiers.setPosition(0.625f), !frontAxis).export(quadMap.get(frontAxis ? quad.m_111306_() : null));
        if (sideAxis) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.0f, 0.375f, 0.375f, 0.625f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.625f, 0.375f, 1.0f, 0.625f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
        }
    }
}

