/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedHalfSlopeModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;
    private final boolean right;

    public FramedHalfSlopeModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        this.right = (Boolean)state.m_61143_((Property)PropertyHolder.RIGHT);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction cutDir;
        Direction quadDir = quad.m_111306_();
        Direction direction = cutDir = this.right ? this.dir.m_122428_() : this.dir.m_122427_();
        if (quadDir == this.dir.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).export(quadMap.get(null));
        } else if (quadDir == this.dir.m_122427_() || quadDir == this.dir.m_122428_()) {
            boolean needOffset = this.right == (quadDir == this.dir.m_122428_());
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), this.top ? 1.0f : 0.0f, this.top ? 0.0f : 1.0f)).applyIf(Modifiers.setPosition(0.5f), needOffset).export(quadMap.get(needOffset ? null : quadDir));
        } else if (!this.top && quadDir == Direction.DOWN || this.top && quadDir == Direction.UP) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(cutDir, 0.5f)).export(quadMap.get(quadDir));
        } else if (quadDir == this.dir) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).export(quadMap.get(quadDir));
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedHalfSlope.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

