/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;

public class FramedInnerCornerSlopeModel
extends FramedBlockModel {
    private final Direction dir;
    private final CornerType type;

    public FramedInnerCornerSlopeModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (this.type.isHorizontal()) {
            this.createHorizontalCorner(quadMap, quad);
        } else {
            this.createVerticalCorner(quadMap, quad);
        }
    }

    private void createHorizontalCorner(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        boolean top = this.type.isTop();
        boolean right = this.type.isRight();
        if (quadDir == Direction.UP && !top || quadDir == Direction.DOWN && top) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), right ? 0.0f : 1.0f, right ? 1.0f : 0.0f)).export(quadMap.get(quadDir));
        } else if (quadDir == this.dir.m_122424_()) {
            Direction cutDir = right ? this.dir.m_122428_() : this.dir.m_122427_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(cutDir, top ? 0.0f : 1.0f, top ? 1.0f : 0.0f)).apply(Modifiers.makeHorizontalSlope(right, 45.0f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(top, right ? 1.0f : 0.0f, right ? 0.0f : 1.0f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).export(quadMap.get(null));
        } else if (quadDir == this.dir.m_122427_() && !right || quadDir == this.dir.m_122428_() && right) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
        }
    }

    private void createVerticalCorner(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        boolean top = this.type.isTop();
        if (quadDir == this.dir.m_122427_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir, top ? 0.0f : 1.0f, top ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).export(quadMap.get(null));
        } else if (quadDir == this.dir.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122427_(), top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122428_(), top ? 0.0f : 1.0f, top ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).export(quadMap.get(null));
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedInnerCornerSlope.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

