/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanel;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedFlatSlopePanelCornerModel;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedFlatExtendedSlopePanelCornerModel
extends FramedBlockModel {
    private final Direction facing;
    private final HorizontalRotation rotation;
    private final HorizontalRotation rotRotation;
    private final Direction orientation;
    private final Direction rotOrientation;

    public FramedFlatExtendedSlopePanelCornerModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        this.rotRotation = this.rotation.rotate(Rotation.COUNTERCLOCKWISE_90);
        this.orientation = this.rotation.withFacing(this.facing);
        this.rotOrientation = this.rotRotation.withFacing(this.facing);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        if (face == this.orientation.m_122424_()) {
            FramedFlatSlopePanelCornerModel.createSideTriangle(quadMap, quad, this.facing, this.rotRotation, true, true);
        } else if (face == this.rotOrientation.m_122424_()) {
            FramedFlatSlopePanelCornerModel.createSideTriangle(quadMap, quad, this.facing, this.rotation, true, true);
        } else if (face == this.orientation || face == this.rotOrientation) {
            if (Utils.isY(face)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122424_(), 0.5f)).export(quadMap.get(face));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122424_(), 0.5f)).export(quadMap.get(face));
            }
        } else if (face == this.facing.m_122424_()) {
            QuadModifier.geometry(quad).apply(FramedFlatSlopePanelCornerModel.createSlopeTriangle(this.facing, this.orientation, false)).apply(FramedSlopePanelModel.createSlope(this.facing, this.orientation)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(FramedFlatSlopePanelCornerModel.createSlopeTriangle(this.facing, this.rotOrientation, true)).apply(FramedSlopePanelModel.createSlope(this.facing, this.rotOrientation)).export(quadMap.get(null));
        } else if (face == this.facing) {
            QuadModifier.geometry(quad).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((BlockState)((Block)FBContent.blockFramedFlatExtendedSlopePanelCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)HorizontalRotation.RIGHT));
    }
}

