/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import org.joml.Quaternionf;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.common.blockentity.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CollapseFace;

public final class CollapsibleBlockOutlineRenderer
implements OutlineRenderer {
    private static final Quaternionf ROTATION = Axis.f_252392_.m_252977_(180.0f);

    @Override
    public void rotateMatrix(PoseStack poseStack, BlockState state) {
        poseStack.m_252781_(ROTATION);
    }

    @Override
    public void draw(BlockState state, Level level, BlockPos pos, PoseStack poseStack, VertexConsumer builder) {
        CollapseFace face = (CollapseFace)((Object)state.m_61143_(PropertyHolder.COLLAPSED_FACE));
        if (face == CollapseFace.NONE) {
            Shapes.m_83144_().m_83224_((pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ) -> OutlineRenderer.drawLine(builder, poseStack, pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ));
        } else {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof FramedCollapsibleBlockEntity)) {
                return;
            }
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            byte[] offets = be.getVertexOffsets();
            Direction faceDir = face.toDirection().m_122424_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            if (faceDir == Direction.UP) {
                poseStack.m_252781_(Quaternions.XP_180);
            } else if (faceDir != Direction.DOWN) {
                poseStack.m_252781_(OutlineRenderer.YN_DIR[faceDir.m_122424_().m_122416_()]);
                poseStack.m_252781_(Quaternions.XN_90);
            }
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            OutlineRenderer.drawLine(builder, poseStack, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0);
            OutlineRenderer.drawLine(builder, poseStack, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0);
            OutlineRenderer.drawLine(builder, poseStack, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            OutlineRenderer.drawLine(builder, poseStack, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            OutlineRenderer.drawLine(builder, poseStack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRenderer.drawLine(builder, poseStack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            OutlineRenderer.drawLine(builder, poseStack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRenderer.drawLine(builder, poseStack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRenderer.drawLine(builder, poseStack, 1.0, 0.0, 1.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            OutlineRenderer.drawLine(builder, poseStack, 1.0, 0.0, 0.0, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0);
            OutlineRenderer.drawLine(builder, poseStack, 0.0, 0.0, 0.0, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0);
            OutlineRenderer.drawLine(builder, poseStack, 0.0, 0.0, 1.0, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0);
            poseStack.m_85849_();
        }
    }

    @Override
    public void draw(BlockState state, PoseStack poseStack, VertexConsumer builder) {
        throw new UnsupportedOperationException();
    }
}

