/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.common.FBContent;

public final class StateLockOverlay
implements IGuiOverlay {
    public static final String LOCK_MESSAGE = "tooltip.framedblocks.lock_state";

    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        IFramedBlock block;
        ItemStack stack = StateLockOverlay.player().m_21205_();
        if (!stack.m_150930_((Item)FBContent.itemFramedKey.get())) {
            return;
        }
        BlockState state = StateLockOverlay.getTargettedBlock();
        Block block2 = state.m_60734_();
        if (!(block2 instanceof IFramedBlock) || !(block = (IFramedBlock)block2).getBlockType().canLockState()) {
            return;
        }
        boolean locked = (Boolean)state.m_61143_((Property)FramedProperties.STATE_LOCKED);
        MutableComponent text = Component.m_237110_((String)LOCK_MESSAGE, (Object[])new Object[]{locked ? IFramedBlock.STATE_LOCKED : IFramedBlock.STATE_UNLOCKED});
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)gui.m_93082_(), (Component)text, (int)(width / 2), (int)(height / 2 + 30), (int)-1);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractWidget.f_93617_);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)(width / 2 - 9), (int)(height / 2 + 40), (int)0, (float)(locked ? 1.0f : 21.0f), (float)167.0f, (int)18, (int)17, (int)256, (int)256);
    }

    private static Player player() {
        return (Player)Preconditions.checkNotNull((Object)Minecraft.m_91087_().f_91074_);
    }

    private static BlockState getTargettedBlock() {
        HitResult hit = Minecraft.m_91087_().f_91077_;
        if (hit instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hit;
            return ((ClientLevel)Preconditions.checkNotNull((Object)Minecraft.m_91087_().f_91073_)).m_8055_(blockHit.m_82425_());
        }
        return Blocks.f_50016_.m_49966_();
    }
}

