/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.FramedFlowerPotBlockEntity;
import xfacthd.framedblocks.common.compat.supplementaries.SupplementariesCompat;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedFlowerPotBlock
extends FramedBlock {
    public FramedFlowerPotBlock() {
        super(BlockType.FRAMED_FLOWER_POT);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.HANGING, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PropertyHolder.HANGING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null && SupplementariesCompat.isLoaded()) {
            state = (BlockState)state.m_61124_((Property)PropertyHolder.HANGING, (Comparable)Boolean.valueOf(context.m_43719_() == Direction.DOWN));
        }
        return state;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction side, BlockState sideState, LevelAccessor level, BlockPos pos, BlockPos sidePos) {
        if (((Boolean)state.m_61143_((Property)PropertyHolder.HANGING)).booleanValue() && side == Direction.UP && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, side, sideState, level, pos, sidePos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)PropertyHolder.HANGING)).booleanValue()) {
            return SupplementariesCompat.canSurviveHanging(level, pos.m_121945_(Direction.UP));
        }
        return true;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = super.m_6227_(state, level, pos, player, hand, hit);
        if (result != InteractionResult.PASS) {
            return result;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedFlowerPotBlockEntity) {
            BlockItem item;
            boolean isFlower;
            FramedFlowerPotBlockEntity be = (FramedFlowerPotBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            Item item2 = stack.m_41720_();
            boolean bl = isFlower = item2 instanceof BlockItem && !FramedFlowerPotBlock.getFlowerPotState((item = (BlockItem)item2).m_40614_()).m_60795_();
            if (isFlower != be.hasFlowerBlock()) {
                if (!level.m_5776_()) {
                    if (isFlower && !be.hasFlowerBlock()) {
                        be.setFlowerBlock(((BlockItem)stack.m_41720_()).m_40614_());
                        player.m_36220_(Stats.f_12961_);
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                    } else {
                        ItemStack flowerStack = new ItemStack((ItemLike)be.getFlowerBlock());
                        if (stack.m_41619_()) {
                            player.m_21008_(hand, flowerStack);
                        } else if (!player.m_36356_(flowerStack)) {
                            player.m_36176_(flowerStack, false);
                        }
                        be.setFlowerBlock(Blocks.f_50016_);
                    }
                }
                level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    protected boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedFlowerPotBlockEntity(pos, state);
    }

    public static BlockState getFlowerPotState(Block flower) {
        Map fullPots = ((FlowerPotBlock)Blocks.f_50276_).getFullPotsView();
        return ((Block)((Supplier)fullPots.getOrDefault(ForgeRegistries.BLOCKS.getKey((Object)flower), ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)Blocks.f_50016_))).get()).m_49966_();
    }
}

