/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedHalfPillarBlock
extends FramedBlock {
    public FramedHalfPillarBlock(BlockType blockType) {
        super(blockType);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_, BlockStateProperties.f_61362_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_43719_().m_122424_());
        return FramedHalfPillarBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public BlockState rotate(BlockState state, Direction side, Rotation rot) {
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)BlockStateProperties.f_61372_);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rot.m_55954_(dir));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, BlockStateProperties.f_61372_, mirror);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeNorth = FramedHalfPillarBlock.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0);
        VoxelShape shapeSouth = FramedHalfPillarBlock.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0);
        VoxelShape shapeEast = FramedHalfPillarBlock.m_49796_((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        VoxelShape shapeWest = FramedHalfPillarBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0);
        VoxelShape shapeUp = FramedHalfPillarBlock.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape shapeDown = FramedHalfPillarBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        for (BlockState state : states) {
            builder.put((Object)state, (Object)(switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.NORTH -> shapeNorth;
                case Direction.EAST -> shapeEast;
                case Direction.SOUTH -> shapeSouth;
                case Direction.WEST -> shapeWest;
                case Direction.UP -> shapeUp;
                case Direction.DOWN -> shapeDown;
            }));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

