/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.prism;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.CtmPredicate;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;

public class FramedSlopedPrismBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> side == ((CompoundDirection)((Object)((Object)state.m_61143_(PropertyHolder.FACING_DIR)))).direction().m_122424_();
    public static final CtmPredicate CTM_PREDICATE_INNER = (state, side) -> {
        CompoundDirection cmpDir = (CompoundDirection)((Object)((Object)state.m_61143_(PropertyHolder.FACING_DIR)));
        return side != cmpDir.direction() && side != cmpDir.orientation();
    };

    public FramedSlopedPrismBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PropertyHolder.FACING_DIR, (Comparable)((Object)CompoundDirection.NORTH_UP)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PropertyHolder.FACING_DIR, BlockStateProperties.f_61362_, FramedProperties.SOLID});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedSlopedPrismBlock.getStateForPlacement(context, this.m_49966_(), this.getBlockType());
    }

    public static BlockState getStateForPlacement(BlockPlaceContext context, BlockState state, IBlockType blockType) {
        Direction orientation;
        Direction face = context.m_43719_();
        if (Utils.isY(face)) {
            orientation = context.m_8125_();
            if (blockType == BlockType.FRAMED_INNER_SLOPED_PRISM || blockType == BlockType.FRAMED_DOUBLE_SLOPED_PRISM) {
                orientation = orientation.m_122424_();
            }
        } else {
            Vec3 subHit = Utils.fraction(context.m_43720_());
            double xz = (Utils.isX(face) ? subHit.m_7094_() : subHit.m_7096_()) - 0.5;
            double y = subHit.m_7098_() - 0.5;
            orientation = Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz) ? (Utils.isX(face) ? (xz < 0.0 ? Direction.SOUTH : Direction.NORTH) : (xz < 0.0 ? Direction.EAST : Direction.WEST)) : (y < 0.0 ? Direction.UP : Direction.DOWN);
        }
        state = (BlockState)state.m_61124_(PropertyHolder.FACING_DIR, (Comparable)((Object)CompoundDirection.of(face, orientation)));
        if (blockType == BlockType.FRAMED_SLOPED_PRISM) {
            state = FramedSlopedPrismBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
        return (BlockState)state.m_61124_(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir.rotate(rot)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
        return (BlockState)state.m_61124_(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir.mirror(mirror)));
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)4.0, (double)15.5), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)12.0)}).m_83296_();
        VoxelShape shapeTop = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.5, (double)12.0, (double)0.0, (double)15.5, (double)16.0, (double)15.5), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0)}).m_83296_();
        VoxelShape shapeRight = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)12.0, (double)15.5, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0)}).m_83296_();
        VoxelShape shapeLeft = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)12.0, (double)16.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0)}).m_83296_();
        VoxelShape shapeUp = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0)}).m_83296_();
        VoxelShape shapeDown = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)12.0, (double)15.5, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0)}).m_83296_();
        for (BlockState state : states) {
            VoxelShape shape;
            CompoundDirection cmpDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
            Direction facing = cmpDir.direction();
            Direction orientation = cmpDir.orientation();
            if (Utils.isY(facing)) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, orientation, facing == Direction.UP ? shapeBottom : shapeTop));
                continue;
            }
            if (orientation == Direction.UP) {
                shape = shapeUp;
            } else if (orientation == Direction.DOWN) {
                shape = shapeDown;
            } else if (orientation == facing.m_122427_()) {
                shape = shapeLeft;
            } else if (orientation == facing.m_122428_()) {
                shape = shapeRight;
            } else {
                throw new IllegalArgumentException("Invalid orientation for direction!");
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)4.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)12.0, (double)15.5, (double)15.5, (double)15.5)});
        VoxelShape shapeTop = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.5, (double)0.0, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)0.0, (double)4.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)16.0, (double)15.5)});
        VoxelShape shapeRight = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)0.5, (double)16.0, (double)4.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)12.0, (double)0.5, (double)16.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)0.5, (double)4.0, (double)15.5, (double)16.0)});
        VoxelShape shapeLeft = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)12.0, (double)0.5, (double)16.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)0.5, (double)16.0, (double)4.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.5, (double)0.5, (double)15.5, (double)15.5, (double)16.0)});
        VoxelShape shapeUp = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)4.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)4.0, (double)16.0)});
        VoxelShape shapeDown = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)4.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)12.0, (double)0.5, (double)15.5, (double)15.5, (double)16.0)});
        for (BlockState state : states) {
            VoxelShape shape;
            CompoundDirection cmdDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
            Direction facing = cmdDir.direction();
            Direction orientation = cmdDir.orientation();
            if (Utils.isY(facing)) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, orientation.m_122424_(), facing == Direction.UP ? shapeBottom : shapeTop));
                continue;
            }
            if (orientation == Direction.UP) {
                shape = shapeUp;
            } else if (orientation == Direction.DOWN) {
                shape = shapeDown;
            } else if (orientation == facing.m_122427_()) {
                shape = shapeLeft;
            } else if (orientation == facing.m_122428_()) {
                shape = shapeRight;
            } else {
                throw new IllegalArgumentException("Invalid orientation for direction!");
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

