/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.rail;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.blockentity.FramedFancyRailSlopeBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedDetectorRailSlopeBlock
extends DetectorRailBlock
implements IFramedBlock {
    private final BlockType type;
    private final ShapeProvider shapes;
    private final BiFunction<BlockPos, BlockState, FramedBlockEntity> beFactory;

    private FramedDetectorRailSlopeBlock(BlockType type, BiFunction<BlockPos, BlockState, FramedBlockEntity> beFactory) {
        super(IFramedBlock.createProperties(type));
        this.type = type;
        this.shapes = type.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
        this.beFactory = beFactory;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52428_, (Comparable)Boolean.valueOf(false)));
    }

    protected void registerDefaultState() {
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PropertyHolder.ASCENDING_RAIL_SHAPE, BlockStateProperties.f_61448_, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.GLOWING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        RailShape shape = FramedUtils.getAscendingRailShapeFromDirection(context.m_8125_());
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean waterlogged = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)shape)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockState newState = super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        if (newState == state) {
            this.updateCulling(level, currentPos, neighborState, direction, false);
        }
        return newState;
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        this.onStateChange(level, pos, oldState, newState);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pFromPos, boolean isMoving) {
        if (!level.m_5776_() && level.m_8055_(pos).m_60713_((Block)this)) {
            this.m_6360_(state, level, pos, block);
        }
    }

    public Property<RailShape> m_7978_() {
        return PropertyHolder.ASCENDING_RAIL_SHAPE;
    }

    public boolean isValidRailShape(RailShape shape) {
        return shape.m_61745_();
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    public boolean m_7923_(BlockState state) {
        return this.useCamoOcclusionShapeForLightOcclusion(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoOcclusionShape(state, level, pos);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getCamoVisualShape(state, level, pos, ctx);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getLight(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return this.getCamoSound(state, level, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getCamoExplosionResistance(state, level, pos, explosion);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.isCamoFlammable(level, pos, face);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getCamoFlammability(level, pos, face);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return this.getCamoDrops(super.m_7381_(state, builder), builder);
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSlipperiness(state, level, pos, entity);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.shapes.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ctx;
        if (context instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)context).m_193113_() instanceof AbstractMinecart) {
            return Shapes.m_83040_();
        }
        return this.m_5940_(state, worldIn, pos, context);
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return this.doesHideNeighborFace(level, pos, state, neighborState, dir);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = FramedUtils.getDirectionFromAscendingRailShape((RailShape)state.m_61143_(PropertyHolder.ASCENDING_RAIL_SHAPE));
        dir = rot.m_55954_(dir);
        return (BlockState)state.m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)FramedUtils.getAscendingRailShapeFromDirection(dir));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = FramedUtils.getDirectionFromAscendingRailShape((RailShape)state.m_61143_(PropertyHolder.ASCENDING_RAIL_SHAPE));
        if (mirror == Mirror.FRONT_BACK && Utils.isZ(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isX(dir)) {
            dir = dir.m_122424_();
            return (BlockState)state.m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)FramedUtils.getAscendingRailShapeFromDirection(dir));
        }
        return state;
    }

    public MaterialColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
        return this.getCamoMapColor(level, pos, defaultColor);
    }

    public float[] getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return this.getCamoBeaconColorMultiplier(level, pos, beaconPos);
    }

    public final BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.beFactory.apply(pos, state);
    }

    @Override
    public IBlockType getBlockType() {
        return this.type;
    }

    public static FramedDetectorRailSlopeBlock normal() {
        return new FramedDetectorRailSlopeBlock(BlockType.FRAMED_DETECTOR_RAIL_SLOPE, FramedBlockEntity::new);
    }

    public static FramedDetectorRailSlopeBlock fancy() {
        return new FramedDetectorRailSlopeBlock(BlockType.FRAMED_FANCY_DETECTOR_RAIL_SLOPE, FramedFancyRailSlopeBlockEntity::new);
    }
}

