/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.predicate.CtmPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleSlopeBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedDoubleSlopeBlock
extends AbstractFramedDoubleBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        if (state.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return dir != null && !Utils.isY(dir);
        }
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        return dir != null && Utils.isY(dir) || dir == facing || dir == facing.m_122424_();
    };

    public FramedDoubleSlopeBlock() {
        super(BlockType.FRAMED_DOUBLE_SLOPE);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedDoubleSlopeBlock.withSlopeType(this.m_49966_(), context.m_43719_(), context.m_8125_(), context.m_43720_());
    }

    @Override
    public SoundType getCamoSound(BlockState state, LevelReader level, BlockPos pos) {
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (type != SlopeType.HORIZONTAL) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FramedDoubleBlockEntity) {
                CamoContainer camo;
                FramedDoubleBlockEntity dbe = (FramedDoubleBlockEntity)blockEntity;
                CamoContainer camoContainer = camo = type == SlopeType.TOP ? dbe.getCamo() : dbe.getCamoTwo();
                if (!camo.isEmpty()) {
                    return camo.getSoundType();
                }
                CamoContainer camoContainer2 = camo = type == SlopeType.TOP ? dbe.getCamoTwo() : dbe.getCamo();
                if (!camo.isEmpty()) {
                    return camo.getSoundType();
                }
            }
            return this.m_49962_(state);
        }
        return super.getCamoSound(state, level, pos);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (state.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return Utils.mirrorCornerBlock(state, mirror);
        }
        return Utils.mirrorFaceBlock(state, mirror);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    @Override
    protected Tuple<BlockState, BlockState> getBlockPair(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        BlockState defState = ((Block)FBContent.blockFramedSlope.get()).m_49966_();
        return new Tuple((Object)((BlockState)((BlockState)defState.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)type))).m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)), (Object)((BlockState)((BlockState)defState.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)(type == SlopeType.HORIZONTAL ? type : type.getOpposite())))).m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing.m_122424_())));
    }

    @Override
    public final BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedDoubleSlopeBlockEntity(pos, state);
    }
}

