/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeslab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.CtmPredicate;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedFlatElevatedSlopeSlabCornerBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        if (((Boolean)state.m_61143_((Property)FramedProperties.TOP)).booleanValue()) {
            return side == Direction.UP;
        }
        return side == Direction.DOWN;
    };
    public static final CtmPredicate CTM_PREDICATE_INNER = (state, side) -> {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir || side == dir.m_122428_()) {
            return true;
        }
        return CTM_PREDICATE.test(state, side);
    };

    public FramedFlatElevatedSlopeSlabCornerBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, FramedProperties.SOLID, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        Direction facing = Utils.isY(face) ? context.m_8125_() : face.m_122424_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing);
        state = FramedFlatElevatedSlopeSlabCornerBlock.withTop(state, context.m_43719_(), context.m_43720_());
        return FramedFlatElevatedSlopeSlabCornerBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction dir;
        Direction face = hit.m_82434_();
        if (face == (dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122424_() || face == dir.m_122427_()) {
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            Vec3 vec = Utils.fraction(hit.m_82450_());
            if (this.getBlockType() == BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER) {
                if (vec.f_82480_ > 0.5 != top) {
                    face = Direction.UP;
                }
            } else {
                double hor;
                Direction perpDir = face == dir.m_122427_() ? dir : dir.m_122428_();
                double d = hor = Utils.isX(perpDir) ? vec.m_7096_() : vec.m_7094_();
                if (!Utils.isPositive(perpDir)) {
                    hor = 1.0 - hor;
                }
                double y = vec.m_7098_();
                if (top) {
                    y = 1.0 - y;
                }
                if ((y -= 0.5) * 2.0 >= hor) {
                    face = Direction.UP;
                }
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            VoxelShape shape = top ? FramedSlopeSlabBlock.SHAPE_TOP : FramedSlopeSlabBlock.SHAPE_BOTTOM.m_83216_(0.0, 0.5, 0.0);
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)FramedFlatElevatedSlopeSlabCornerBlock.m_49796_((double)0.0, (double)(top ? 8.0 : 0.0), (double)0.0, (double)16.0, (double)(top ? 16.0 : 8.0), (double)16.0));
            builder.put((Object)state, (Object)Shapes.m_83113_((VoxelShape)Utils.rotateShape(Direction.NORTH, facing, shape), (VoxelShape)Utils.rotateShape(Direction.NORTH, facing.m_122428_(), shape), (BooleanOp)BooleanOp.f_82689_));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            VoxelShape shape = top ? FramedSlopeSlabBlock.SHAPE_TOP : FramedSlopeSlabBlock.SHAPE_BOTTOM.m_83216_(0.0, 0.5, 0.0);
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)FramedFlatElevatedSlopeSlabCornerBlock.m_49796_((double)0.0, (double)(top ? 8.0 : 0.0), (double)0.0, (double)16.0, (double)(top ? 16.0 : 8.0), (double)16.0));
            builder.put((Object)state, (Object)Shapes.m_83110_((VoxelShape)Utils.rotateShape(Direction.NORTH, facing, shape), (VoxelShape)Utils.rotateShape(Direction.NORTH, facing.m_122428_(), shape)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

