/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

public final class CornerPillarSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return switch (type) {
                case BlockType.FRAMED_CORNER_PILLAR -> CornerPillarSkipPredicate.testAgainstPillar(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> CornerPillarSkipPredicate.testAgainstCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_PANEL -> CornerPillarSkipPredicate.testAgainstPanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> CornerPillarSkipPredicate.testAgainstDoublePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_STAIRS -> CornerPillarSkipPredicate.testAgainstStairs(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> CornerPillarSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> CornerPillarSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> CornerPillarSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstDoubleSlopePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> CornerPillarSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> CornerPillarSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> CornerPillarSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> CornerPillarSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> CornerPillarSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> CornerPillarSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> CornerPillarSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> CornerPillarSkipPredicate.testAgainstDoubleHalfSlope(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> CornerPillarSkipPredicate.testAgainstVerticalSlopedStairs(level, pos, state, dir, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (CornerPillarSkipPredicate.getHalfDir(dir, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (CornerPillarSkipPredicate.getCornerDir(dir, side).isEqualTo(CornerPillarSkipPredicate.getCornerDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (CornerPillarSkipPredicate.getCornerDir(dir, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (CornerPillarSkipPredicate.getHalfDir(dir, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerPillarSkipPredicate.testAgainstPanel(level, pos, state, dir, (BlockState)states.m_14418_(), side) || CornerPillarSkipPredicate.testAgainstPanel(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        Half adjHalf = (Half)adjState.m_61143_((Property)BlockStateProperties.f_61402_);
        if (CornerPillarSkipPredicate.getHalfDir(dir, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (CornerPillarSkipPredicate.getCornerDir(dir, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (CornerPillarSkipPredicate.getHalfDir(dir, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (CornerPillarSkipPredicate.getCornerDir(dir, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerPillarSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, (BlockState)states.m_14418_(), side) || CornerPillarSkipPredicate.testAgainstPillar(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (CornerPillarSkipPredicate.getHalfDir(dir, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (CornerPillarSkipPredicate.getCornerDir(dir, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (CornerPillarSkipPredicate.getHalfDir(dir, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (CornerPillarSkipPredicate.getHalfDir(dir, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerPillarSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, (BlockState)states.m_14418_(), side) || CornerPillarSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerPillarSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, (BlockState)states.m_14418_(), side) || CornerPillarSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerPillarSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, (BlockState)states.m_14418_(), side) || CornerPillarSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (CornerPillarSkipPredicate.getHalfDir(dir, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (CornerPillarSkipPredicate.getHalfDir(dir, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerPillarSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerPillarSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerPillarSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, (BlockState)states.m_14418_(), side) || CornerPillarSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (CornerPillarSkipPredicate.getHalfDir(dir, side).isEqualTo(HalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerPillarSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, (BlockState)states.m_14418_(), side) || CornerPillarSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerPillarSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, (BlockState)states.m_14418_(), side) || CornerPillarSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (CornerPillarSkipPredicate.getHalfDir(dir, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    public static HalfDir getHalfDir(Direction dir, Direction side) {
        if (side == dir) {
            return HalfDir.fromDirections(side, dir.m_122428_());
        }
        if (side == dir.m_122428_()) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }

    public static CornerDir getCornerDir(Direction dir, Direction side) {
        if (Utils.isY(side)) {
            return CornerDir.fromDirections(side, dir, dir.m_122428_());
        }
        return CornerDir.NULL;
    }
}

