/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopepanel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;

public final class FlatSlopePanelCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT);
        if (side == dir) {
            return !front && SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return switch (type) {
                case BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatSlopePanelCorner(level, pos, state, dir, front, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, front, rot, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, state, dir, front, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, state, dir, front, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, state, dir, front, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatExtendedInnerDoubleSlopePanelCorner(level, pos, state, dir, front, rot, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> FlatSlopePanelCornerSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, front, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> FlatSlopePanelCornerSkipPredicate.testAgainstDoubleSlopePanel(level, pos, state, dir, front, rot, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> FlatSlopePanelCornerSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, state, dir, front, rot, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> FlatSlopePanelCornerSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, state, dir, front, rot, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstFlatSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatSlopePanelCornerSkipPredicate.getTriDir(dir, rot, front, side).isEqualTo(FlatSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (FlatSlopePanelCornerSkipPredicate.getTriDir(dir, rot, front, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, front, rot, (BlockState)states.m_14418_(), side) || FlatSlopePanelCornerSkipPredicate.testAgainstFlatSlopePanelCorner(level, pos, state, dir, front, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, front, rot, (BlockState)states.m_14418_(), side) || FlatSlopePanelCornerSkipPredicate.testAgainstFlatSlopePanelCorner(level, pos, state, dir, front, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, front, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatExtendedInnerDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopePanelCornerSkipPredicate.testAgainstFlatSlopePanelCorner(level, pos, state, dir, front, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (FlatSlopePanelCornerSkipPredicate.getTriDir(dir, rot, front, side).isEqualTo(SlopePanelSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopePanelCornerSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, front, rot, (BlockState)states.m_14418_(), side) || FlatSlopePanelCornerSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, front, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopePanelCornerSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, front, rot, (BlockState)states.m_14418_(), side) || FlatSlopePanelCornerSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, front, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopePanelCornerSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, front, rot, (BlockState)states.m_14419_(), side);
    }

    public static HalfTriangleDir getTriDir(Direction dir, HorizontalRotation rot, boolean front, Direction side) {
        if (side == rot.withFacing(dir).m_122424_() || side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir)) {
            Direction shortEdge = rot.getOpposite().withFacing(dir);
            return HalfTriangleDir.fromDirections(dir, shortEdge, !front);
        }
        return HalfTriangleDir.NULL;
    }
}

