/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopepanel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

public final class SlopePanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        boolean front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT);
        if (side == dir) {
            return !front && SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstDoubleSlopePanel(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatSlopePanelCorner(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatExtendedInnerSlopePanelCorner(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> SlopePanelSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_PANEL -> SlopePanelSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> SlopePanelSkipPredicate.testAgainstDoublePanel(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> SlopePanelSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlopePanelSkipPredicate.testAgainstStairs(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlopePanelSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> SlopePanelSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> SlopePanelSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS, BlockType.FRAMED_HALF_SLOPE -> SlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> SlopePanelSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> SlopePanelSkipPredicate.testAgainstDoubleHalfSlope(level, pos, state, dir, rot, front, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> SlopePanelSkipPredicate.testAgainstVerticalSlopedStairs(level, pos, state, dir, rot, front, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (SlopePanelSkipPredicate.getHalfDir(dir, rot, front, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (SlopePanelSkipPredicate.getTriDir(dir, rot, front, side).isEqualTo(SlopePanelSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (SlopePanelSkipPredicate.getHalfDir(dir, rot, front, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, front, (BlockState)states.m_14418_(), side) || SlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, front, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, front, (BlockState)states.m_14418_(), side) || SlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, front, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, rot, front, (BlockState)states.m_14418_(), side) || SlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, front, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (SlopePanelSkipPredicate.getTriDir(dir, rot, front, side).isEqualTo(FlatSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (SlopePanelSkipPredicate.getHalfDir(dir, rot, front, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (SlopePanelSkipPredicate.getTriDir(dir, rot, front, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (SlopePanelSkipPredicate.getHalfDir(dir, rot, front, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, front, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, front, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, rot, front, (BlockState)states.m_14418_(), side) || SlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, front, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatExtendedInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstFlatSlopePanelCorner(level, pos, state, dir, rot, front, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlopePanelSkipPredicate.getHalfDir(dir, rot, front, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (SlopePanelSkipPredicate.getHalfDir(dir, rot, front, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, front, (BlockState)states.m_14418_(), side) || SlopePanelSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, front, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (SlopePanelSkipPredicate.getHalfDir(dir, rot, front, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        if (SlopePanelSkipPredicate.getHalfDir(dir, rot, front, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstStairs(level, pos, state, dir, rot, front, (BlockState)states.m_14418_(), side) || SlopePanelSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, front, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (SlopePanelSkipPredicate.getHalfDir(dir, rot, front, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, rot, front, (BlockState)states.m_14418_(), side) || SlopePanelSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, rot, front, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (SlopePanelSkipPredicate.getHalfDir(dir, rot, front, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, front, (BlockState)states.m_14418_(), side) || SlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, front, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, front, (BlockState)states.m_14418_(), side) || SlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, front, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (SlopePanelSkipPredicate.getHalfDir(dir, rot, front, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    public static HalfTriangleDir getTriDir(Direction dir, HorizontalRotation rot, boolean front, Direction side) {
        Direction perpRotDir = rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir);
        if (side.m_122434_() == perpRotDir.m_122434_()) {
            Direction shortEdge = rot.getOpposite().withFacing(dir);
            return HalfTriangleDir.fromDirections(dir, shortEdge, !front);
        }
        return HalfTriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, HorizontalRotation rot, boolean front, Direction side) {
        if (side == rot.withFacing(dir).m_122424_()) {
            return HalfDir.fromDirections(side, front ? dir.m_122424_() : dir);
        }
        return HalfDir.NULL;
    }
}

