/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.VerticalHalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

public final class StairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            return switch (type) {
                case BlockType.FRAMED_STAIRS -> StairsSkipPredicate.testAgainstStairs(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> StairsSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> StairsSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLAB -> StairsSkipPredicate.testAgainstSlab(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> StairsSkipPredicate.testAgainstDoubleSlab(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> StairsSkipPredicate.testAgainstEdge(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_PANEL -> StairsSkipPredicate.testAgainstPanel(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> StairsSkipPredicate.testAgainstDoublePanel(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> StairsSkipPredicate.testAgainstPillar(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> StairsSkipPredicate.testAgainstCorner(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> StairsSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> StairsSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> StairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> StairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> StairsSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> StairsSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> StairsSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> StairsSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> StairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> StairsSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> StairsSkipPredicate.testAgainstDoubleSlopePanel(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> StairsSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> StairsSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> StairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> StairsSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> StairsSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> StairsSkipPredicate.testAgainstDoubleHalfSlope(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE -> StairsSkipPredicate.testAgainstVerticalDoubleHalfSlope(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> StairsSkipPredicate.testAgainstSlopedStairs(level, pos, state, dir, shape, half, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> StairsSkipPredicate.testAgainstVerticalSlopedStairs(level, pos, state, dir, shape, half, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        if (StairsSkipPredicate.getStairDir(dir, shape, half, side).isEqualTo(StairsSkipPredicate.getStairDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (StairsSkipPredicate.getCornerDir(dir, shape, half, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstStairs(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstEdge(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (StairsSkipPredicate.getStairDir(dir, shape, half, side).isEqualTo(HalfStairsSkipPredicate.getStairDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (StairsSkipPredicate.getCornerDir(dir, shape, half, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(SlabSkipPredicate.getHalfDir(adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstSlab(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstSlab(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (StairsSkipPredicate.getCornerDir(dir, shape, half, side).isEqualTo(SlabEdgeSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstPanel(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstPanel(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (StairsSkipPredicate.getCornerDir(dir, shape, half, side).isEqualTo(CornerPillarSkipPredicate.getCornerDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (StairsSkipPredicate.getCornerDir(dir, shape, half, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (StairsSkipPredicate.getStairDir(dir, shape, half, side).isEqualTo(VerticalStairsSkipPredicate.getStairDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (StairsSkipPredicate.getCornerDir(dir, shape, half, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstPillar(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (StairsSkipPredicate.getStairDir(dir, shape, half, side).isEqualTo(VerticalHalfStairsSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(VerticalHalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (StairsSkipPredicate.getCornerDir(dir, shape, half, side).isEqualTo(VerticalHalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(SlopeSlabSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstPanel(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstPanel(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(HalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(VerticalHalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return StairsSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
        }
        return StairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return StairsSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, shape, half, (BlockState)states.m_14418_(), side) || StairsSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, shape, half, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(SlopedStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (StairsSkipPredicate.getHalfDir(dir, shape, half, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    public static TriangleDir getStairDir(Direction dir, StairsShape shape, Half half, Direction side) {
        Direction dirTwo = half == Half.TOP ? Direction.UP : Direction.DOWN;
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case StairsShape.STRAIGHT -> {
                if (side == dir.m_122427_() || side == dir.m_122428_()) {
                    yield TriangleDir.fromDirections(dir, dirTwo);
                }
                yield TriangleDir.NULL;
            }
            case StairsShape.INNER_LEFT -> {
                if (side == dir.m_122424_()) {
                    yield TriangleDir.fromDirections(dir.m_122428_(), dirTwo);
                }
                if (side == dir.m_122427_()) {
                    yield TriangleDir.fromDirections(dir, dirTwo);
                }
                if (side == dirTwo) {
                    yield TriangleDir.fromDirections(dir, dir.m_122428_());
                }
                yield TriangleDir.NULL;
            }
            case StairsShape.INNER_RIGHT -> {
                if (side == dir.m_122424_()) {
                    yield TriangleDir.fromDirections(dir.m_122427_(), dirTwo);
                }
                if (side == dir.m_122428_()) {
                    yield TriangleDir.fromDirections(dir, dirTwo);
                }
                if (side == dirTwo) {
                    yield TriangleDir.fromDirections(dir, dir.m_122427_());
                }
                yield TriangleDir.NULL;
            }
            case StairsShape.OUTER_LEFT -> {
                if (side == dir) {
                    yield TriangleDir.fromDirections(dir.m_122428_(), dirTwo);
                }
                if (side == dir.m_122428_()) {
                    yield TriangleDir.fromDirections(dir, dirTwo);
                }
                yield TriangleDir.NULL;
            }
            case StairsShape.OUTER_RIGHT -> side == dir ? TriangleDir.fromDirections(dir.m_122427_(), dirTwo) : (side == dir.m_122427_() ? TriangleDir.fromDirections(dir, dirTwo) : TriangleDir.NULL);
        };
    }

    public static HalfDir getHalfDir(Direction dir, StairsShape shape, Half half, Direction side) {
        Direction edge = half == Half.TOP ? Direction.UP : Direction.DOWN;
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case StairsShape.INNER_LEFT, StairsShape.INNER_RIGHT -> HalfDir.NULL;
            case StairsShape.STRAIGHT -> {
                if (side == dir.m_122424_()) {
                    yield HalfDir.fromDirections(side, edge);
                }
                yield HalfDir.NULL;
            }
            case StairsShape.OUTER_LEFT -> {
                if (side == dir.m_122424_() || side == dir.m_122427_()) {
                    yield HalfDir.fromDirections(side, edge);
                }
                yield HalfDir.NULL;
            }
            case StairsShape.OUTER_RIGHT -> side == dir.m_122424_() || side == dir.m_122428_() ? HalfDir.fromDirections(side, edge) : HalfDir.NULL;
        };
    }

    public static CornerDir getCornerDir(Direction dir, StairsShape shape, Half half, Direction side) {
        Direction normal;
        Direction direction = normal = half == Half.TOP ? Direction.DOWN : Direction.UP;
        if (side != normal) {
            return CornerDir.NULL;
        }
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case StairsShape.STRAIGHT, StairsShape.INNER_LEFT, StairsShape.INNER_RIGHT -> CornerDir.NULL;
            case StairsShape.OUTER_LEFT -> CornerDir.fromDirections(side, dir, dir.m_122428_());
            case StairsShape.OUTER_RIGHT -> CornerDir.fromDirections(side, dir, dir.m_122427_());
        };
    }
}

