/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia;

import com.epherical.croptopia.Composter;
import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.ForgeAdapter;
import com.epherical.croptopia.biome.CropModifier;
import com.epherical.croptopia.biome.SaltModifier;
import com.epherical.croptopia.biome.TreeModifier;
import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import com.epherical.croptopia.config.Config;
import com.epherical.croptopia.datagen.CroptopiaBiomeData;
import com.epherical.croptopia.items.GuideBookItem;
import com.epherical.croptopia.items.SeedItem;
import com.epherical.croptopia.listeners.BlockBreakEvent;
import com.epherical.croptopia.listeners.EntitySpawn;
import com.epherical.croptopia.listeners.Harvest;
import com.epherical.croptopia.listeners.LootTableModification;
import com.epherical.croptopia.loot.AdditionalTableModifier;
import com.epherical.croptopia.loot.EntityModifier;
import com.epherical.croptopia.loot.SpawnChestModifier;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.helpers.FarmlandCrop;
import com.epherical.croptopia.register.helpers.TreeCrop;
import com.epherical.croptopia.register.helpers.Utensil;
import com.epherical.croptopia.registry.GeneratorRegistry;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="croptopia")
public class CroptopiaForge {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_SERIALIZER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"croptopia");
    public static final DeferredRegister<BiomeModifier> BIOME_MODIFIER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (String)"croptopia");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"croptopia");
    public static Config config;
    public static CreativeModeTab CROPTOPIA_ITEM_GROUP;
    public static CroptopiaMod mod;
    private static boolean hasRun;

    public CroptopiaForge() {
        config = new Config();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::enqueueIMC);
        bus.addListener(this::processIMC);
        bus.addListener(this::doClientStuff);
        CroptopiaBiomeData data = new CroptopiaBiomeData(bus);
        BIOME_MODIFIER.register(bus);
        BIOME_SERIALIZER.register(bus);
        BIOME_SERIALIZER.register("trees", TreeModifier::makeCodec);
        BIOME_SERIALIZER.register("crops", CropModifier::makeCodec);
        BIOME_SERIALIZER.register("salt", SaltModifier::makeCodec);
        GLM.register(bus);
        GLM.register("spawn_loot", SpawnChestModifier.CODEC);
        GLM.register("entity_modifier", EntityModifier.CODEC);
        GLM.register("table_adder", AdditionalTableModifier.CODEC);
        bus.addListener(data::getData);
        bus.addListener(config::initConfig);
        MinecraftForge.EVENT_BUS.addListener(CroptopiaForge::onWorldLoad);
        MinecraftForge.EVENT_BUS.register((Object)new LootTableModification());
        MinecraftForge.EVENT_BUS.register((Object)new Harvest());
        MinecraftForge.EVENT_BUS.register((Object)new BlockBreakEvent());
        MinecraftForge.EVENT_BUS.register((Object)new EntitySpawn());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CroptopiaForge.config.config);
        EventListenerHelper.getListenerList(PlayerInteractEvent.RightClickBlock.class);
        mod = new CroptopiaMod(new ForgeAdapter());
    }

    private void setup(FMLCommonSetupEvent event) {
        Composter.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        CroptopiaMod.cropBlocks.forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
        BlockColors colors = Minecraft.m_91087_().m_91298_();
        colors.m_92589_((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.m_46113_(), CroptopiaMod.leafBlocks.toArray(new Block[0]));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.COOKING_POT));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.FOOD_PRESS));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.FRYING_PAN));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.MORTAR_AND_PESTLE));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterWaterItem", () -> new ItemStack((ItemLike)Content.WATER_BOTTLE));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterMilkItem", () -> new ItemStack((ItemLike)Content.MILK_BOTTLE));
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLDedicatedServerSetupEvent event) {
    }

    public static ResourceLocation createIdentifier(String name) {
        return new ResourceLocation("croptopia", name);
    }

    private static void modifyVillagerFoodItems() {
    }

    private static void modifyVillagerGatherables() {
    }

    public static void onWorldLoad(LevelEvent.Load event) {
        if (!hasRun) {
            CroptopiaForge.modifyVillagerFoodItems();
            CroptopiaForge.modifyVillagerGatherables();
            hasRun = true;
        }
    }

    static {
        CROPTOPIA_ITEM_GROUP = null;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerTab(CreativeModeTabEvent.Register event) {
            event.registerCreativeModeTab(new ResourceLocation("croptopia", "tab"), builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.croptopia")).m_257501_((featureFlagSet, output, bl) -> BuiltInRegistries.f_257033_.m_6579_().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("croptopia")).sorted(Comparator.comparing(entry -> BuiltInRegistries.f_257033_.m_7447_((Object)((Item)entry.getValue())))).forEach(entry -> output.m_246326_((ItemLike)entry.getValue()))).m_257737_(() -> new ItemStack((ItemLike)Content.COFFEE)));
        }

        @SubscribeEvent
        public static void modifyTabs(CreativeModeTabEvent.BuildContents event) {
            if (event.getTab().equals(CreativeModeTabs.f_256776_)) {
                event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_220175_), (Object)new ItemStack((ItemLike)Content.CINNAMON.getSapling()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                TreeCrop.copy().stream().map(TreeCrop::getSaplingItem).map(ItemStack::new).forEachOrdered(stack -> event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_151013_), stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                FarmlandCrop.copy().stream().map(FarmlandCrop::getSeedItem).map(ItemStack::new).forEachOrdered(stack -> event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42588_), stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                event.getEntries().putBefore((Object)new ItemStack((ItemLike)Items.f_41835_), (Object)new ItemStack((ItemLike)Content.SALT_ORE), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            } else if (event.getTab().equals(CreativeModeTabs.f_256869_)) {
                Utensil.copy().stream().map(ItemStack::new).forEachOrdered(stack -> event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42409_), stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            }
        }

        @SubscribeEvent
        public static void onRegister(RegisterEvent event) {
            if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
                Content.GUIDE = new GuideBookItem(CroptopiaMod.createGroup());
                event.register(ForgeRegistries.Keys.ITEMS, CroptopiaForge.createIdentifier("guide"), () -> Content.GUIDE);
                Content.registerItems((id, item) -> {
                    event.register(ForgeRegistries.Keys.ITEMS, id, () -> item);
                    if (item instanceof ItemNameBlockItem) {
                        ((ItemNameBlockItem)item).m_6192_(Item.f_41373_, item);
                    }
                    if (item instanceof SeedItem) {
                        SeedItem it = (SeedItem)((Object)item);
                        CroptopiaCropBlock block = (CroptopiaCropBlock)it.m_40614_();
                        block.setSeed(it);
                    }
                    return item;
                });
                ArrayList<SeedItem> chickenItems = new ArrayList<SeedItem>(CroptopiaMod.seeds);
                chickenItems.addAll(Arrays.stream(Chicken.f_28233_.m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toList()));
                Chicken.f_28233_ = Ingredient.m_43929_((ItemLike[])chickenItems.toArray(new ItemLike[0]));
                ArrayList<SeedItem> parrotItems = new ArrayList<SeedItem>(Parrot.f_29357_);
                parrotItems.addAll(CroptopiaMod.seeds);
                Parrot.f_29357_ = Sets.newHashSet(parrotItems);
                ArrayList<FarmlandCrop> pigItems = new ArrayList<FarmlandCrop>(Arrays.asList(Content.YAM, Content.SWEETPOTATO));
                pigItems.addAll(Arrays.stream(Pig.f_29458_.m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toList()));
                Pig.f_29458_ = Ingredient.m_43929_((ItemLike[])pigItems.toArray(new ItemLike[0]));
                GeneratorRegistry.init();
                Config.setFeatures(config);
            }
            if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCKS)) {
                Content.registerBlocks((id, object) -> {
                    event.register(ForgeRegistries.Keys.BLOCKS, blockRegisterHelper -> blockRegisterHelper.register(id, object));
                    return object;
                });
            }
        }
    }
}

