/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="croptopia", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private final ForgeConfigSpec.Builder CONFIG_BUILDER = new ForgeConfigSpec.Builder();
    public ForgeConfigSpec config;
    public static ForgeConfigSpec.ConfigValue<Boolean> rightClickHarvest;
    public static ForgeConfigSpec.ConfigValue<Boolean> disableSaltGeneration;
    public final Map<TreeConfiguration, TreeBuilder> builderMap = new HashMap<TreeConfiguration, TreeBuilder>();
    private final Multimap<ResourceLocation, String> features = HashMultimap.create();
    public static boolean canRightClickHarvest;
    public static boolean isSaltDisabled;

    public Config() {
        rightClickHarvest = this.CONFIG_BUILDER.comment("allows the user to right click harvest crops").translation("croptopia.config.rightclickharvest").define("rightClickHarvest", true);
        disableSaltGeneration = this.CONFIG_BUILDER.comment("allows the user to disable salt generation in the world, default is false").define("disableSaltGeneration", false);
        List<TreeConfiguration> trees = TreeConfiguration.init();
        this.CONFIG_BUILDER.comment("Croptopia tree generation").push("worldGeneration");
        for (TreeConfiguration tree : trees) {
            this.builderMap.put(tree, new TreeBuilder(this.CONFIG_BUILDER, tree));
        }
        this.CONFIG_BUILDER.pop();
        this.config = this.CONFIG_BUILDER.build();
    }

    @SubscribeEvent
    public void initConfig(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == this.config) {
            canRightClickHarvest = (Boolean)rightClickHarvest.get();
            isSaltDisabled = (Boolean)disableSaltGeneration.get();
            this.features.clear();
            for (Map.Entry<TreeConfiguration, TreeBuilder> entry : this.builderMap.entrySet()) {
                for (String s : (List)entry.getValue().acceptableBiomes.get()) {
                    this.features.put((Object)new ResourceLocation(s), (Object)entry.getKey().featureKey);
                }
            }
        }
    }

    public static void setFeatures(Config config) {
        for (TreeConfiguration treeConfiguration : TreeConfiguration.init()) {
            for (String key : treeConfiguration.keys) {
                config.features.put((Object)new ResourceLocation(key), (Object)treeConfiguration.featureKey);
            }
        }
    }

    private static ResourceLocation bygID(String name) {
        return new ResourceLocation("byg", name);
    }

    public Map<TreeConfiguration, TreeBuilder> getBuilderMap() {
        return this.builderMap;
    }

    public Multimap<ResourceLocation, String> getFeatures() {
        return this.features;
    }

    public static class TreeConfiguration {
        String featureKey;
        List<ResourceKey<Biome>> treesInBiome;
        List<String> keys;

        public TreeConfiguration(String featureKey, List<ResourceKey<Biome>> treesInBiome) {
            this.featureKey = featureKey;
            this.treesInBiome = treesInBiome;
            this.keys = new ArrayList<String>();
            for (ResourceKey<Biome> biomeResourceKey : treesInBiome) {
                this.keys.add(biomeResourceKey.m_135782_().toString());
            }
        }

        public static void createSameTreeConfigs(SetMultimap<String, ResourceKey<Biome>> map, Collection<ResourceKey<Biome>> biomes, String ... keys) {
            for (String key : keys) {
                map.putAll((Object)key, biomes);
            }
        }

        public static List<TreeConfiguration> init() {
            List<ResourceKey<Biome>> forestBiomes = Arrays.asList(Biomes.f_48205_, Biomes.f_186767_, Biomes.f_48179_);
            List<ResourceKey<Biome>> jungleBiomes = Arrays.asList(Biomes.f_48222_, Biomes.f_186769_);
            List<ResourceKey<Biome>> plainsKeys = Arrays.asList(Biomes.f_48202_, Biomes.f_48176_);
            List<ResourceKey<Biome>> darkForestKeys = Arrays.asList(Biomes.f_48151_);
            HashMultimap biomes = HashMultimap.create();
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, forestBiomes, "lime_tree_configured", "pear_tree_configured", "apricot_tree_configured", "avocado_tree_configured", "star_fruit_tree_configured", "lemon_tree_configured", "cherry_tree_configured", "plum_tree_configured", "persimmon_tree_configured", "orange_tree_configured", "nectarine_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, jungleBiomes, "date_tree_configured", "dragon_fruit_tree_configured", "mango_tree_configured", "nutmeg_tree_configured", "coconut_tree_configured", "kumquat_tree_configured", "grapefruit_tree_configured", "banana_tree_configured", "fig_tree_configured", "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, plainsKeys, "apple_tree_configured", "orange_tree_configured", "peach_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, darkForestKeys, "almond_tree_configured", "cashew_tree_configured", "pecan_tree_configured", "walnut_tree_configured");
            ResourceKey aspenForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("aspen_forest"));
            ResourceKey autumnalValley = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("autumnal_valley"));
            ResourceKey bayou = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("bayou"));
            ResourceKey blackForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("black_forest"));
            ResourceKey canadianShield = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("canadian_shield"));
            ResourceKey cherryBlossomForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("cherry_blossom_forest"));
            ResourceKey cikaWoods = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("cika_woods"));
            ResourceKey coniferousForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("coniferous_forest"));
            ResourceKey cragGardens = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("crag_gardens"));
            ResourceKey cypressSwamplands = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("cypress_swamplands"));
            ResourceKey deadSea = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("dead_sea"));
            ResourceKey daciteRidges = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("dacite_ridges"));
            ResourceKey windsweptDunes = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("windswept_dunes"));
            ResourceKey ebonyWoods = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("ebony_woods"));
            ResourceKey forgottenForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("forgotten_forest"));
            ResourceKey grove = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("temperate_grove"));
            ResourceKey guianaShield = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("guiana_shield"));
            ResourceKey jacarandaForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("jacaranda_forest"));
            ResourceKey mapleTaiga = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("maple_taiga"));
            ResourceKey coconinoMeadow = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("coconino_meadow"));
            ResourceKey mojaveDesert = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("mojave_desert"));
            ResourceKey lushTundra = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("lush_tundra"));
            ResourceKey orchard = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("orchard"));
            ResourceKey prairie = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("prairie"));
            ResourceKey redOakForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("red_oak_forest"));
            ResourceKey redRockValley = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("red_rock_valley"));
            ResourceKey roseFields = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("rose_fields"));
            ResourceKey autumnalForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("autumnal_forest"));
            ResourceKey autumnalTaiga = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("autumnal_taiga"));
            ResourceKey shatteredGlacier = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("shattered_glacier"));
            ResourceKey firecrackerShrubland = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("firecracker_shrubland"));
            ResourceKey sierraBadlands = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("sierra_badlands"));
            ResourceKey skyrisVale = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("skyris_vale"));
            ResourceKey redwoodThicket = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("redwood_thicket"));
            ResourceKey frostedTaiga = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("frosted_taiga"));
            ResourceKey frostedConiferousForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("frosted_coniferous_forest"));
            ResourceKey fragmentForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("fragment_forest"));
            ResourceKey tropicalIsland = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("tropical_islands"));
            ResourceKey tropicalRainforest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("tropical_rainforest"));
            ResourceKey twilightMeadow = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("twilight_meadow"));
            ResourceKey weepingWitchForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("weeping_witch_forest"));
            ResourceKey whiteMangroveMarshes = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("white_mangrove_marshes"));
            ResourceKey temperateRainforest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("temperate_rainforest"));
            ResourceKey zelkovaForest = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Config.bygID("zelkova_forest"));
            List<ResourceKey<Biome>> bygWoods = Arrays.asList(aspenForest, orchard, redOakForest);
            List<ResourceKey<Biome>> cherry = Arrays.asList(cherryBlossomForest);
            List<ResourceKey<Biome>> nutty = Arrays.asList(weepingWitchForest, daciteRidges, ebonyWoods, mapleTaiga, twilightMeadow);
            List<ResourceKey<Biome>> jungleByg = Arrays.asList(cragGardens, tropicalIsland, tropicalRainforest);
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, Collections.singleton(prairie), "apple_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, Arrays.asList(jacarandaForest, autumnalForest, autumnalTaiga), "pear_tree_configured", "persimmon_tree_configured", "plum_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, Arrays.asList(cypressSwamplands, whiteMangroveMarshes, temperateRainforest), "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, jungleByg, "date_tree_configured", "dragon_fruit_tree_configured", "mango_tree_configured", "nutmeg_tree_configured", "coconut_tree_configured", "kumquat_tree_configured", "grapefruit_tree_configured", "banana_tree_configured", "fig_tree_configured", "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, nutty, "almond_tree_configured", "cashew_tree_configured", "pecan_tree_configured", "walnut_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, cherry, "cherry_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, bygWoods, "lime_tree_configured", "pear_tree_configured", "apricot_tree_configured", "avocado_tree_configured", "star_fruit_tree_configured", "lemon_tree_configured", "cherry_tree_configured", "plum_tree_configured", "persimmon_tree_configured", "orange_tree_configured", "nectarine_tree_configured");
            ArrayList<TreeConfiguration> allTreeConfigs = new ArrayList<TreeConfiguration>();
            for (Map.Entry entry : biomes.asMap().entrySet()) {
                allTreeConfigs.add(new TreeConfiguration((String)entry.getKey(), new ArrayList<ResourceKey<Biome>>((Collection)entry.getValue())));
            }
            return allTreeConfigs;
        }
    }

    public static class TreeBuilder {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> acceptableBiomes;

        private TreeBuilder(ForgeConfigSpec.Builder builder, TreeConfiguration configuration) {
            this.acceptableBiomes = builder.comment("Settings for " + configuration.featureKey).push(configuration.featureKey).defineList("biomes", configuration.keys, o -> true);
            builder.pop();
        }
    }

    public static class CropConfiguration {
        String seed;
        List<String> biomes;

        public CropConfiguration(String seed, List<String> biomes) {
            this.seed = seed;
            this.biomes = biomes;
        }

        public static void init() {
        }
    }

    public static class CropBuilder {
    }
}

