/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EntityModifier
extends LootModifier {
    public static final Supplier<Codec<EntityModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> EntityModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(o -> o.item), (App)Codec.INT.fieldOf("weight").forGetter(o -> o.weight), (App)Codec.INT.fieldOf("min").forGetter(o -> o.min), (App)Codec.INT.fieldOf("max").forGetter(o -> o.max))).apply((Applicative)instance, EntityModifier::new)));
    private final LootPool pool;
    private final Item item;
    private final int weight;
    private final int min;
    private final int max;

    protected EntityModifier(LootItemCondition[] conditionsIn, Item item, int weight, int min, int max) {
        super(conditionsIn);
        this.item = item;
        this.weight = weight;
        this.min = min;
        this.max = max;
        LootPool.Builder builder = LootPool.m_79043_();
        builder.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
        builder.m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.0f));
        builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max), (boolean)false)));
        this.pool = builder.m_79082_();
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        this.pool.m_79053_(arg_0 -> generatedLoot.add(arg_0), context);
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

