/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaSaplingBlock;
import com.epherical.croptopia.blocks.LeafCropBlock;
import com.epherical.croptopia.generator.CroptopiaSaplingGenerator;
import com.epherical.croptopia.items.CropItem;
import com.epherical.croptopia.items.CroptopiaSaplingItem;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.util.BlockConvertible;
import com.epherical.croptopia.util.FoodConstructor;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import org.jetbrains.annotations.Nullable;

public class TreeCrop
implements ItemConvertibleWithPlural,
BlockConvertible {
    private static final List<TreeCrop> TREE_CROPS = new ArrayList<TreeCrop>();
    private final String name;
    private final boolean isPlural;
    private final TagCategory category;
    private final Item item;
    private final Block leaves;
    private ResourceKey<ConfiguredFeature<?, ?>> tree;
    private final ConfiguredFeature<TreeConfiguration, ?> treeConfig;
    private final CroptopiaSaplingItem saplingItem;
    private final CroptopiaSaplingBlock saplingBlock;
    private static final boolean datagen = Boolean.getBoolean("fabric-api.datagen");
    private ResourceLocation placedFeatureName;

    public TreeCrop(String name, boolean plural, Block logType, Block leafType, TagCategory category, FoodConstructor constructor, int base, int randA, int randB) {
        Objects.requireNonNull(leafType);
        Objects.requireNonNull(category);
        Objects.requireNonNull(logType);
        this.name = name;
        this.isPlural = plural;
        this.category = category;
        this.item = constructor == null ? Items.f_42410_ : new CropItem(CroptopiaMod.createGroup().m_41489_(FoodConstructor.createFood(constructor)));
        this.leaves = CroptopiaMod.createLeavesBlock();
        this.treeConfig = TreeCrop.createTreeGen(base, randA, randB, logType, leafType, this.leaves);
        this.saplingBlock = new CroptopiaSaplingBlock(new CroptopiaSaplingGenerator(() -> this.tree), CroptopiaMod.createSaplingSettings());
        this.saplingItem = new CroptopiaSaplingItem((Block)this.saplingBlock, this.leaves, leafType, CroptopiaMod.createGroup());
        TREE_CROPS.add(this);
        if (datagen) {
            System.out.println("Generating Data for TreeCrops");
            this.placedFeatureName = new ResourceLocation("croptopia", this.name() + "_tree_configured");
        }
    }

    @Override
    public Block asBlock() {
        return this.leaves;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean hasPlural() {
        return this.isPlural;
    }

    public Item m_5456_() {
        return this.item;
    }

    public void setTree(ResourceKey<ConfiguredFeature<?, ?>> tree) {
        this.tree = tree;
    }

    public ConfiguredFeature<TreeConfiguration, ?> getTreeConfig() {
        return this.treeConfig;
    }

    public ResourceKey<ConfiguredFeature<?, ?>> getTree() {
        return this.tree;
    }

    public CroptopiaSaplingBlock getSaplingBlock() {
        return this.saplingBlock;
    }

    public CroptopiaSaplingItem getSaplingItem() {
        return this.saplingItem;
    }

    public Block getLeaves() {
        return this.leaves;
    }

    public TagCategory getTagCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getPlacedFeatureName() {
        return this.placedFeatureName;
    }

    public static List<TreeCrop> copy() {
        return TREE_CROPS;
    }

    public static void registerBlocks(RegisterFunction<Block> register) {
        for (TreeCrop treeCrop : TREE_CROPS) {
            register.register(CroptopiaMod.createIdentifier(treeCrop.name() + "_crop"), treeCrop.asBlock());
            CroptopiaMod.cropBlocks.add(treeCrop.asBlock());
            CroptopiaMod.cropBlocks.add((Block)treeCrop.saplingBlock);
            CroptopiaMod.leafBlocks.add(treeCrop.asBlock());
            treeCrop.tree = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("croptopia", treeCrop.name() + "_tree"));
            register.register(CroptopiaMod.createIdentifier(treeCrop.name() + "_sapling"), (Block)treeCrop.getSaplingBlock());
        }
    }

    public static void registerItems(RegisterFunction<Item> register) {
        for (TreeCrop treeCrop : TREE_CROPS) {
            if (!Objects.equals(treeCrop.name(), "apple")) {
                register.register(CroptopiaMod.createIdentifier(treeCrop.name()), treeCrop.m_5456_());
                CroptopiaMod.cropItems.add(treeCrop.m_5456_());
            }
            register.register(CroptopiaMod.createIdentifier(treeCrop.name() + "_sapling"), (Item)treeCrop.getSaplingItem());
        }
    }

    public static ConfiguredFeature<TreeConfiguration, ?> createTreeGen(int i, int j, int k, Block logType, Block leafType, Block leafCrop) {
        return new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)SimpleStateProvider.m_191384_((BlockState)logType.m_49966_()), (TrunkPlacer)new StraightTrunkPlacer(i, j, k), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)leafType.m_49966_(), 90).m_146271_((Object)((BlockState)leafCrop.m_49966_().m_61124_((Property)LeafCropBlock.AGE, (Comparable)Integer.valueOf(3))), 20).m_146270_()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_().m_68251_());
    }
}

