/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynResourceGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.ResourceManager;

public abstract class DynClientResourcesGenerator
extends DynResourceGenerator<DynamicTexturePack> {
    protected DynClientResourcesGenerator(DynamicTexturePack pack) {
        super(pack);
    }

    @Override
    public void register() {
        super.register();
        if (!PlatformHelper.isData()) {
            ClientPlatformHelper.addClientReloadListener(this, ((DynamicTexturePack)this.dynamicPack).resourcePackName);
        }
        MoonlightEventsHelper.addListener(this::addDynamicTranslations, AfterLanguageLoadEvent.class);
    }

    @Override
    protected PackRepository getRepository() {
        return Minecraft.m_91087_().m_91099_();
    }

    public boolean alreadyHasTextureAtLocation(ResourceManager manager, ResourceLocation res) {
        return this.alreadyHasAssetAtLocation(manager, res, ResType.TEXTURES);
    }

    public void addTextureIfNotPresent(ResourceManager manager, String relativePath, Supplier<TextureImage> textureSupplier) {
        ResourceLocation res;
        ResourceLocation resourceLocation = res = relativePath.contains(":") ? new ResourceLocation(relativePath) : new ResourceLocation(((DynamicTexturePack)this.dynamicPack).mainNamespace, relativePath);
        if (!this.alreadyHasTextureAtLocation(manager, res)) {
            TextureImage textureImage = null;
            try {
                textureImage = textureSupplier.get();
            }
            catch (Exception e) {
                this.getLogger().error("Failed to generate texture {}: {}", (Object)res, (Object)e);
            }
            if (textureImage == null) {
                this.getLogger().warn("Could not generate texture {}", (Object)res);
            } else {
                ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(res, textureImage);
            }
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent languageEvent) {
    }
}

