/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.gson.JsonElement;
import com.mojang.bridge.game.GameVersion;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.metadata.pack.PackMetadataSectionSerializer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlagSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicResourcePack
implements PackResources {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final boolean hidden;
    protected final boolean fixed;
    protected final Pack.Position position;
    protected final PackType packType;
    protected final Pack.Info info;
    protected final PackMetadataSection metadata;
    protected final Component title;
    protected final ResourceLocation resourcePackName;
    protected final Set<String> namespaces = new HashSet<String>();
    protected final Map<ResourceLocation, byte[]> resources = new ConcurrentHashMap<ResourceLocation, byte[]>();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final String mainNamespace;
    protected boolean generateDebugResources;

    protected DynamicResourcePack(ResourceLocation name, PackType type) {
        this(name, type, Pack.Position.TOP, false, false);
    }

    protected DynamicResourcePack(ResourceLocation name, PackType type, Pack.Position position, boolean fixed, boolean hidden) {
        this.packType = type;
        MutableComponent component = Component.m_237115_((String)LangBuilder.getReadableName(name.m_135827_() + "_dynamic_resources"));
        this.resourcePackName = name;
        this.mainNamespace = name.m_135827_();
        this.namespaces.add(name.m_135827_());
        this.title = Component.m_237115_((String)LangBuilder.getReadableName(name.toString()));
        this.position = position;
        this.fixed = fixed;
        this.hidden = hidden;
        this.metadata = new PackMetadataSection((Component)component, type.m_143756_((GameVersion)SharedConstants.m_183709_()));
        this.info = new Pack.Info(this.metadata.m_10373_(), this.metadata.m_10374_(), FeatureFlagSet.m_246902_());
        this.generateDebugResources = PlatformHelper.isDev();
    }

    public void setGenerateDebugResources(boolean generateDebugResources) {
        this.generateDebugResources = generateDebugResources;
    }

    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    public Component getTitle() {
        return this.title;
    }

    public String m_5542_() {
        return this.title.getString();
    }

    public String toString() {
        return this.m_5542_();
    }

    public void registerPack() {
        PlatformHelper.registerResourcePack(this.packType, () -> Pack.m_245512_((String)this.m_5542_(), (Component)this.getTitle(), (boolean)true, s -> this, (Pack.Info)this.info, (PackType)this.packType, (Pack.Position)Pack.Position.TOP, (boolean)this.fixed, (PackSource)PackSource.f_10528_));
    }

    @PlatformOnly(value={"forge"})
    public boolean isHidden() {
        return this.hidden;
    }

    public Set<String> m_5698_(PackType packType) {
        return this.namespaces;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        return (T)(serializer instanceof PackMetadataSectionSerializer ? this.metadata : null);
    }

    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        return () -> new ByteArrayInputStream(this.rootResources.get(fileName));
    }

    public void m_8031_(PackType packType, String namespace, String id, PackResources.ResourceOutput output) {
        if (packType == this.packType && packType == PackType.SERVER_DATA && this.namespaces.contains(namespace)) {
            this.resources.entrySet().stream().filter(r -> ((ResourceLocation)r.getKey()).m_135827_().equals(namespace) && ((ResourceLocation)r.getKey()).m_135815_().startsWith(id)).forEach(r -> output.accept((Object)((ResourceLocation)r.getKey()), () -> new ByteArrayInputStream((byte[])r.getValue())));
        }
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation id) {
        return () -> {
            if (type != this.packType) {
                throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.resourcePackName));
            }
            byte[] res = this.resources.get(id);
            if (res != null) {
                try {
                    return new ByteArrayInputStream(res);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            throw this.makeFileNotFoundException(String.format("%s/%s/%s", type.m_10305_(), id.m_135827_(), id.m_135815_()));
        };
    }

    public void close() {
    }

    public FileNotFoundException makeFileNotFoundException(String path) {
        return new FileNotFoundException(String.format("'%s' in ResourcePack '%s'", path, this.resourcePackName));
    }

    protected void addBytes(ResourceLocation path, byte[] bytes) {
        this.namespaces.add(path.m_135827_());
        this.resources.put(path, bytes);
        if (this.generateDebugResources) {
            try {
                Path p = Paths.get("debug", "generated_resource_pack").resolve(path.m_135827_() + "/" + path.m_135815_());
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.write(p, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addResource(StaticResource resource) {
        this.addBytes(resource.location, resource.data);
    }

    private void addJson(ResourceLocation path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            LOGGER.error("Failed to write JSON {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    public void addJson(ResourceLocation location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    public void addBytes(ResourceLocation location, byte[] bytes, ResType resType) {
        this.addBytes(resType.getPath(location), bytes);
    }

    public PackType getPackType() {
        return this.packType;
    }
}

