/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockType {
    private final BiMap<String, Object> children = HashBiMap.create();
    public final ResourceLocation id;

    protected BlockType(ResourceLocation resourceLocation) {
        this.id = resourceLocation;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getTypeName() {
        return this.id.m_135815_();
    }

    public String getNamespace() {
        return this.id.m_135827_();
    }

    public String getAppendableId() {
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public String toString() {
        return this.id.toString();
    }

    public abstract String getTranslationKey();

    public String getVariantId(String baseName) {
        String namespace;
        String string = namespace = this.isVanilla() ? "" : this.getNamespace() + "/";
        if (baseName.contains("%s")) {
            return namespace + String.format(baseName, this.getTypeName());
        }
        return namespace + baseName + "_" + this.getTypeName();
    }

    public String getVariantId(String baseName, boolean prefix) {
        return this.getVariantId(prefix ? baseName + "_%s" : "%s_" + baseName);
    }

    public String getVariantId(String postfix, String prefix) {
        return this.getVariantId(prefix + "_%s_" + postfix);
    }

    public String getReadableName() {
        return LangBuilder.getReadableName(this.getTypeName());
    }

    public boolean isVanilla() {
        return this.getNamespace().equals("minecraft");
    }

    @Nullable
    protected <V> V findRelatedEntry(String appendedName, Registry<V> reg) {
        return this.findRelatedEntry(appendedName, "", reg);
    }

    @Nullable
    protected <V> V findRelatedEntry(String append, String postPend, Registry<V> reg) {
        Optional o;
        if (this.id.m_135827_().equals("tfc") && (o = reg.m_6612_(new ResourceLocation(this.id.m_135827_(), "wood/" + postPend + "/" + this.id.m_135815_()))).isPresent()) {
            return (V)o.get();
        }
        Object post = postPend.isEmpty() ? "" : "_" + postPend;
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_" + append + (String)post), new ResourceLocation(this.id.m_135827_(), append + "_" + this.id.m_135815_() + (String)post), new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_planks_" + append + (String)post)};
        Object found = null;
        for (ResourceLocation r : targets) {
            if (!reg.m_7804_(r)) continue;
            found = reg.m_7745_(r);
            break;
        }
        return (V)found;
    }

    public Set<Map.Entry<String, Object>> getChildren() {
        return this.children.entrySet();
    }

    @Nullable
    public Item getItemOfThis(String key) {
        Item i;
        Object v = this.getChild(key);
        return v instanceof Item ? (i = (Item)v) : null;
    }

    @Nullable
    public Block getBlockOfThis(String key) {
        Block b;
        Object v = this.getChild(key);
        return v instanceof Block ? (b = (Block)v) : null;
    }

    @Nullable
    public Object getChild(String key) {
        return this.children.get((Object)key);
    }

    public void addChild(String genericName, @Nullable Object itemLike) {
        if (itemLike != null) {
            this.children.put((Object)genericName, itemLike);
            BlockTypeRegistry<?> v = BlockSetInternal.getRegistry(this.getClass());
            if (v != null) {
                v.mapBlockToType(itemLike, this);
            }
        }
    }

    @ApiStatus.Internal
    public abstract void initializeChildrenBlocks();

    @ApiStatus.Internal
    public abstract void initializeChildrenItems();

    public abstract ItemLike mainChild();

    @Nullable
    public String getChildKey(Object child) {
        return (String)this.children.inverse().get(child);
    }

    @Nullable
    public static Object changeType(Object current, BlockType originalMat, BlockType destinationMat) {
        if (destinationMat == originalMat) {
            return current;
        }
        String key = originalMat.getChildKey(current);
        if (key != null) {
            return destinationMat.getChild(key);
        }
        return null;
    }

    @Nullable
    public static Item changeItemType(Item current, BlockType originalMat, BlockType destinationMat) {
        Block il;
        Item i;
        BlockItem bi;
        Object blockChanged;
        Object changed = BlockType.changeType(current, originalMat, destinationMat);
        if (changed == null && current instanceof BlockItem && (blockChanged = BlockType.changeType((bi = (BlockItem)current).m_40614_(), originalMat, destinationMat)) instanceof Block && (i = (il = (Block)blockChanged).m_5456_()) != Items.f_41852_) {
            changed = i;
        }
        if (changed instanceof ItemLike) {
            ItemLike il2 = (ItemLike)changed;
            return il2.m_5456_();
        }
        return null;
    }

    @Nullable
    public static Block changeBlockType(@NotNull Block current, BlockType originalMat, BlockType destinationMat) {
        BlockItem bi;
        Item i;
        Object itemChanged;
        Object changed = BlockType.changeType(current, originalMat, destinationMat);
        if (changed == null && current.m_5456_() != Items.f_41852_ && (itemChanged = BlockType.changeType(current.m_5456_(), originalMat, destinationMat)) instanceof BlockItem && (i = (bi = (BlockItem)itemChanged).m_5456_()) != Items.f_41852_) {
            changed = i;
        }
        if (changed instanceof Block) {
            Block b = (Block)changed;
            return b;
        }
        return null;
    }

    @FunctionalInterface
    public static interface SetFinder<T extends BlockType>
    extends Supplier<Optional<T>> {
        @Override
        public Optional<T> get();
    }
}

