/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.leaves;

import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class LeavesType
extends BlockType {
    public final Block leaves;
    private final Supplier<WoodType> woodType;

    protected LeavesType(ResourceLocation id, Block leaves) {
        this(id, leaves, (Supplier<WoodType>)Suppliers.memoize(() -> Objects.requireNonNullElse(WoodTypeRegistry.getValue(id), WoodTypeRegistry.OAK_TYPE)));
    }

    protected LeavesType(ResourceLocation id, Block leaves, Supplier<WoodType> woodType) {
        super(id);
        this.leaves = leaves;
        this.woodType = woodType;
    }

    public WoodType getWoodType() {
        return this.woodType.get();
    }

    @Override
    public ItemLike mainChild() {
        return this.leaves;
    }

    @Override
    public String getTranslationKey() {
        return "leaves_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("leaves", this.leaves);
        this.woodType.get();
    }

    @Override
    public void initializeChildrenItems() {
    }

    public static class Finder
    implements BlockType.SetFinder<LeavesType> {
        private final Supplier<Block> leavesFinder;
        private final Supplier<WoodType> woodFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> leaves, @Nullable Supplier<WoodType> wood) {
            this.id = id;
            this.leavesFinder = leaves;
            this.woodFinder = wood;
        }

        public static Finder simple(String modId, String leavesTypeName, String leavesName) {
            return new Finder(new ResourceLocation(modId, leavesTypeName), () -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(modId, leavesName)), null);
        }

        public static Finder simple(String modId, String leavesTypeName, String leavesName, String woodTypeName) {
            return new Finder(new ResourceLocation(modId, leavesTypeName), () -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(modId, leavesName)), () -> (WoodType)WoodTypeRegistry.INSTANCE.get(new ResourceLocation(woodTypeName)));
        }

        @Override
        public Optional<LeavesType> get() {
            if (PlatformHelper.isModLoaded(this.id.m_135827_())) {
                try {
                    Block leaves = this.leavesFinder.get();
                    Block d = (Block)BuiltInRegistries.f_256975_.m_7745_(BuiltInRegistries.f_256975_.m_122315_());
                    if (leaves != d && leaves != null) {
                        if (this.woodFinder == null) {
                            return Optional.of(new LeavesType(this.id, leaves));
                        }
                        return Optional.of(new LeavesType(this.id, leaves, this.woodFinder));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Moonlight.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

