/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WoodType
extends BlockType {
    public final Material material;
    public final Block planks;
    public final Block log;
    @Nullable
    private final net.minecraft.world.level.block.state.properties.WoodType vanillaType;

    protected WoodType(ResourceLocation id, Block baseBlock, Block logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
        this.material = baseBlock.m_49966_().m_60767_();
        String i = id.m_135827_().equals("minecraft") ? "" : id.m_135827_() + "/" + id.m_135815_();
        Optional<net.minecraft.world.level.block.state.properties.WoodType> o = net.minecraft.world.level.block.state.properties.WoodType.m_61843_().filter(v -> v.m_61846_().equals(i)).findAny();
        this.vanillaType = o.orElse(null);
    }

    @Nullable
    protected Block findLogRelatedBlock(String append, String postpend) {
        Optional o;
        if (this.id.m_135827_().equals("tfc") && (o = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(this.id.m_135827_(), "wood/" + append + "_" + postpend + "/" + this.id.m_135815_()))).isPresent()) {
            return (Block)o.get();
        }
        Object post = postpend.isEmpty() ? "" : "_" + postpend;
        ResourceLocation id = this.getId();
        String logN = Utils.getID(this.log).m_135815_();
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), logN + "_" + append + (String)post), new ResourceLocation(id.m_135827_(), append + "_" + logN + (String)post), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + append + (String)post), new ResourceLocation(id.m_135827_(), append + "_" + id.m_135815_() + (String)post)};
        Block found = null;
        for (ResourceLocation r : targets) {
            if (!BuiltInRegistries.f_256975_.m_7804_(r)) continue;
            found = (Block)BuiltInRegistries.f_256975_.m_7745_(r);
            break;
        }
        return found;
    }

    public Material getMaterial() {
        return this.material;
    }

    @Override
    public ItemLike mainChild() {
        return this.planks;
    }

    @Nullable
    public net.minecraft.world.level.block.state.properties.WoodType toVanilla() {
        return this.vanillaType;
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.material.m_76335_();
    }

    public MaterialColor getColor() {
        return this.material.m_76339_();
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("planks", this.planks);
        this.addChild("log", this.log);
        this.addChild("leaves", this.findRelatedEntry("leaves", BuiltInRegistries.f_256975_));
        this.addChild("stripped_log", this.findLogRelatedBlock("stripped", "log"));
        this.addChild("stripped_wood", this.findLogRelatedBlock("stripped", "wood"));
        this.addChild("wood", this.findRelatedEntry("wood", BuiltInRegistries.f_256975_));
        this.addChild("slab", this.findRelatedEntry("slab", BuiltInRegistries.f_256975_));
        this.addChild("stairs", this.findRelatedEntry("stairs", BuiltInRegistries.f_256975_));
        this.addChild("fence", this.findRelatedEntry("fence", BuiltInRegistries.f_256975_));
        this.addChild("fence_gate", this.findRelatedEntry("fence_gate", BuiltInRegistries.f_256975_));
        this.addChild("door", this.findRelatedEntry("door", BuiltInRegistries.f_256975_));
        this.addChild("trapdoor", this.findRelatedEntry("trapdoor", BuiltInRegistries.f_256975_));
        this.addChild("button", this.findRelatedEntry("button", BuiltInRegistries.f_256975_));
        this.addChild("pressure_plate", this.findRelatedEntry("pressure_plate", BuiltInRegistries.f_256975_));
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("boat", this.findRelatedEntry("boat", BuiltInRegistries.f_257033_));
        this.addChild("sign", this.findRelatedEntry("sign", BuiltInRegistries.f_257033_));
    }

    public static class Finder
    implements BlockType.SetFinder<WoodType> {
        private final Map<String, ResourceLocation> childNames = new HashMap<String, ResourceLocation>();
        private final Supplier<Block> planksFinder;
        private final Supplier<Block> logFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> planks, Supplier<Block> log) {
            this.id = id;
            this.planksFinder = planks;
            this.logFinder = log;
        }

        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(new ResourceLocation(modId, woodTypeName), new ResourceLocation(modId, planksName), new ResourceLocation(modId, logName));
        }

        public static Finder simple(ResourceLocation woodTypeName, ResourceLocation planksName, ResourceLocation logName) {
            return new Finder(woodTypeName, () -> (Block)BuiltInRegistries.f_256975_.m_7745_(planksName), () -> (Block)BuiltInRegistries.f_256975_.m_7745_(logName));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, new ResourceLocation(this.id.m_135827_(), childName));
        }

        public void addChild(String childType, ResourceLocation childName) {
            this.childNames.put(childType, childName);
        }

        @Override
        @ApiStatus.Internal
        public Optional<WoodType> get() {
            if (PlatformHelper.isModLoaded(this.id.m_135827_())) {
                try {
                    Block plank = this.planksFinder.get();
                    Block log = this.logFinder.get();
                    Block d = (Block)BuiltInRegistries.f_256975_.m_7745_(BuiltInRegistries.f_256975_.m_122315_());
                    if (plank != d && log != d && plank != null && log != null) {
                        WoodType w = new WoodType(this.id, plank, log);
                        this.childNames.forEach((key, value) -> w.addChild((String)key, BuiltInRegistries.f_256975_.m_7745_(value)));
                        return Optional.of(w);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Moonlight.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

