/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import java.util.Collection;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public class WoodTypeRegistry
extends BlockTypeRegistry<WoodType> {
    public static final WoodType OAK_TYPE = new WoodType(new ResourceLocation("oak"), Blocks.f_50705_, Blocks.f_49999_);
    public static final WoodTypeRegistry INSTANCE = new WoodTypeRegistry();

    public static Collection<WoodType> getTypes() {
        return INSTANCE.getValues();
    }

    @Nullable
    public static WoodType getValue(ResourceLocation name) {
        return (WoodType)INSTANCE.get(name);
    }

    public static WoodType fromNBT(String name) {
        return (WoodType)INSTANCE.getFromNBT(name);
    }

    public WoodTypeRegistry() {
        super(WoodType.class, "wood_type");
    }

    @Override
    public WoodType getDefaultType() {
        return OAK_TYPE;
    }

    @Override
    public Optional<WoodType> detectTypeFromBlock(Block baseBlock, ResourceLocation baseRes) {
        Material mat;
        BlockState state;
        String name = null;
        String path = baseRes.m_135815_();
        if (baseRes.m_135827_().equals("tfc")) {
            Optional log;
            if (path.contains("wood/planks/") && (log = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(baseRes.m_135827_(), path.replace("planks", "log")))).isPresent()) {
                ResourceLocation id = new ResourceLocation(baseRes.m_135827_(), path.replace("wood/planks/", ""));
                return Optional.of(new WoodType(id, baseBlock, (Block)log.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        String namespace = baseRes.m_135827_();
        if (!(name == null || namespace.equals("securitycraft") || namespace.equals("absentbydesign") || (state = baseBlock.m_49966_()).m_61147_().size() > 2 || baseBlock instanceof SlabBlock || (mat = state.m_60767_()) != Material.f_76320_ && mat != Material.f_76321_)) {
            name = name.replace("/", "_");
            ResourceLocation id = new ResourceLocation(baseRes.m_135827_(), name);
            Block logBlock = WoodTypeRegistry.findLog(id);
            if (logBlock != null) {
                return Optional.of(new WoodType(id, baseBlock, logBlock));
            }
        }
        return Optional.empty();
    }

    @Nullable
    private static Block findLog(ResourceLocation id) {
        ResourceLocation[] test = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), id.m_135815_() + "_log"), new ResourceLocation(id.m_135827_(), "log_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_log"), new ResourceLocation("log_" + id.m_135815_()), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_stem"), new ResourceLocation(id.m_135827_(), "stem_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_stem"), new ResourceLocation("stem_" + id.m_135815_()), new ResourceLocation(id.m_135827_(), "stalk_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_stalk"), new ResourceLocation("stalk_" + id.m_135815_())};
        Block temp = null;
        for (ResourceLocation r : test) {
            if (!BuiltInRegistries.f_256975_.m_7804_(r)) continue;
            temp = (Block)BuiltInRegistries.f_256975_.m_7745_(r);
            break;
        }
        return temp;
    }

    @Override
    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(w -> {
            if (language.isDefault()) {
                language.addEntry(w.getTranslationKey(), w.getReadableName());
            }
        });
    }
}

