/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Utils {
    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem, boolean bothSides) {
        if (!player.f_19853_.f_46443_ || bothSides) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)player.m_7500_()));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.f_19853_.f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)player.m_7500_()));
        }
    }

    public static void swapItemNBT(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.f_19853_.f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)false));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack newItem) {
        if (!player.f_19853_.f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)player.m_21120_(hand).m_41777_(), (Player)player, (ItemStack)newItem, (boolean)player.m_7500_()));
        }
    }

    public static void addStackToExisting(Player player, ItemStack stack) {
        Inventory inv = player.m_150109_();
        boolean added = false;
        for (int j = 0; j < inv.f_35974_.size(); ++j) {
            if (!inv.m_8020_(j).m_150930_(stack.m_41720_()) || !inv.m_36040_(j, stack)) continue;
            added = true;
            break;
        }
        if (!added && inv.m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    public static int getXPinaBottle(int bottleCount, RandomSource rand) {
        int xp = 0;
        for (int i = 0; i < bottleCount; ++i) {
            xp += 3 + rand.m_188503_(5) + rand.m_188503_(5);
        }
        return xp;
    }

    public static VoxelShape rotateVoxelShape(VoxelShape source, Direction direction) {
        AtomicReference<VoxelShape> newShape = new AtomicReference<VoxelShape>(Shapes.m_83040_());
        source.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vec3 min = new Vec3(minX - 0.5, minY - 0.5, minZ - 0.5);
            Vec3 max = new Vec3(maxX - 0.5, maxY - 0.5, maxZ - 0.5);
            Vec3 v1 = MthUtils.rotateVec3(min, direction);
            Vec3 v2 = MthUtils.rotateVec3(max, direction);
            VoxelShape s = Shapes.m_166049_((double)(0.5 + Math.min(v1.f_82479_, v2.f_82479_)), (double)(0.5 + Math.min(v1.f_82480_, v2.f_82480_)), (double)(0.5 + Math.min(v1.f_82481_, v2.f_82481_)), (double)(0.5 + Math.max(v1.f_82479_, v2.f_82479_)), (double)(0.5 + Math.max(v1.f_82480_, v2.f_82480_)), (double)(0.5 + Math.max(v1.f_82481_, v2.f_82481_)));
            newShape.set(Shapes.m_83110_((VoxelShape)((VoxelShape)newShape.get()), (VoxelShape)s));
        });
        return newShape.get();
    }

    public static ResourceLocation getID(Block object) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(EntityType<?> object) {
        return BuiltInRegistries.f_256780_.m_7981_(object);
    }

    public static ResourceLocation getID(Biome object) {
        return Utils.hackyGetRegistryAccess().m_175515_(Registries.f_256952_).m_7981_((Object)object);
    }

    public static ResourceLocation getID(ConfiguredFeature<?, ?> object) {
        return Utils.hackyGetRegistryAccess().m_175515_(Registries.f_256911_).m_7981_(object);
    }

    public static ResourceLocation getID(Item object) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(Fluid object) {
        return BuiltInRegistries.f_257020_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(BlockEntityType<?> object) {
        return BuiltInRegistries.f_257049_.m_7981_(object);
    }

    public static ResourceLocation getID(RecipeSerializer<?> object) {
        return BuiltInRegistries.f_256769_.m_7981_(object);
    }

    public static ResourceLocation getID(SoftFluid object) {
        return SoftFluidRegistry.getID(object);
    }

    public static ResourceLocation getID(MapDecorationType<?, ?> object) {
        return MapDecorationRegistry.getID(object);
    }

    public static ResourceLocation getID(Object object) {
        if (object instanceof Block) {
            Block b = (Block)object;
            return Utils.getID(b);
        }
        if (object instanceof Item) {
            Item b = (Item)object;
            return Utils.getID(b);
        }
        if (object instanceof EntityType) {
            EntityType b = (EntityType)object;
            return Utils.getID(b);
        }
        if (object instanceof Biome) {
            Biome b = (Biome)object;
            return Utils.getID(b);
        }
        if (object instanceof Fluid) {
            Fluid b = (Fluid)object;
            return Utils.getID(b);
        }
        if (object instanceof BlockEntityType) {
            BlockEntityType b = (BlockEntityType)object;
            return Utils.getID(b);
        }
        if (object instanceof RecipeSerializer) {
            RecipeSerializer b = (RecipeSerializer)object;
            return Utils.getID(b);
        }
        if (object instanceof ConfiguredFeature) {
            ConfiguredFeature c = (ConfiguredFeature)object;
            return Utils.getID(c);
        }
        if (object instanceof Supplier) {
            Supplier s = (Supplier)object;
            return Utils.getID(s.get());
        }
        if (object instanceof SoftFluid) {
            SoftFluid s = (SoftFluid)object;
            return Utils.getID(s);
        }
        if (object instanceof MapDecorationType) {
            MapDecorationType s = (MapDecorationType)object;
            return Utils.getID(s);
        }
        throw new UnsupportedOperationException("Unknown class type " + object.getClass());
    }

    public static RegistryAccess hackyGetRegistryAccess() {
        ClientLevel level;
        MinecraftServer s = PlatformHelper.getCurrentServer();
        if (s != null) {
            return s.m_206579_();
        }
        if (!PlatformHelper.getPhysicalSide().isServer() && (level = Minecraft.m_91087_().f_91073_) != null) {
            return level.m_8891_();
        }
        throw new UnsupportedOperationException("Failed to get registry access. This is a bug");
    }

    public static BlockBehaviour.Properties copyPropertySafe(BlockBehaviour blockBehaviour) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_60926_((BlockBehaviour)blockBehaviour);
        p.m_60953_(s -> 0);
        p.m_222979_(BlockBehaviour.OffsetType.NONE);
        p.m_155949_(blockBehaviour.m_60590_());
        return p;
    }
}

