/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.client.GenericSimpleResourceReloadListener;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.util.profiling.ProfilerFiller;

public class SoftFluidClient
extends GenericSimpleResourceReloadListener {
    private static final List<ResourceLocation> TEXTURES_TO_STITCH = new ArrayList<ResourceLocation>();
    private static final HashMap<ResourceLocation, Integer> PARTICLE_COLORS = new HashMap();

    public SoftFluidClient() {
        super("textures/soft_fluids", ".png");
    }

    @Override
    public void apply(List<ResourceLocation> locations, ResourceManager manager, ProfilerFiller filler) {
        TEXTURES_TO_STITCH.clear();
        TEXTURES_TO_STITCH.addAll(locations);
        RenderedTexturesManager.clearCache();
    }

    public static int get(SoftFluid s) {
        return PARTICLE_COLORS.getOrDefault(SoftFluidRegistry.getID(s), -1);
    }

    public static List<ResourceLocation> getTexturesToStitch() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        TEXTURES_TO_STITCH.forEach(e -> list.add(new ResourceLocation(e.m_135827_(), "soft_fluids/" + e.m_135815_())));
        return list;
    }

    public static void refresh() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null) {
            return;
        }
        Set<Map.Entry<ResourceKey<SoftFluid>, SoftFluid>> v = SoftFluidRegistry.getEntries();
        PARTICLE_COLORS.clear();
        for (Map.Entry<ResourceKey<SoftFluid>, SoftFluid> entry : v) {
            ResourceLocation location;
            SoftFluid s = entry.getValue();
            ResourceLocation key = entry.getKey().m_135782_();
            if (PARTICLE_COLORS.containsKey(key) || s.isColored() || (location = s.getStillTexture()) == null) continue;
            TextureAtlas textureMap = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_);
            TextureAtlasSprite sprite = textureMap.m_118316_(location);
            int averageColor = -1;
            try {
                averageColor = SoftFluidClient.getColorFrom(sprite, s.getTintColor());
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Failed to load particle color for " + sprite + " using current resource pack. might be a broken png.mcmeta");
            }
            PARTICLE_COLORS.put(key, averageColor);
        }
    }

    private static int getColorFrom(TextureAtlasSprite sprite, int tint) {
        SpriteContents c = sprite.m_245424_();
        if (sprite == null || c.m_245088_() == 0) {
            return -1;
        }
        int tintR = tint >> 16 & 0xFF;
        int tintG = tint >> 8 & 0xFF;
        int tintB = tint & 0xFF;
        int total = 0;
        int totalR = 0;
        int totalB = 0;
        int totalG = 0;
        for (int tryFrame = 0; tryFrame < c.m_245088_(); ++tryFrame) {
            try {
                for (int x = 0; x < c.m_246492_(); ++x) {
                    for (int y = 0; y < c.m_245330_(); ++y) {
                        int pixel = ClientPlatformHelper.getPixelRGBA(sprite, tryFrame, x, y);
                        int pixelB = pixel >> 16 & 0xFF;
                        int pixelG = pixel >> 8 & 0xFF;
                        int pixelR = pixel & 0xFF;
                        ++total;
                        totalR += pixelR;
                        totalG += pixelG;
                        totalB += pixelB;
                    }
                }
                break;
            }
            catch (Exception e) {
                total = 0;
                totalR = 0;
                totalB = 0;
                totalG = 0;
                continue;
            }
        }
        if (total <= 0) {
            return -1;
        }
        return FastColor.ARGB32.m_13660_((int)255, (int)(totalR / total * tintR / 255), (int)(totalG / total * tintG / 255), (int)(totalB / total * tintB / 255));
    }
}

