/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MapItem.class})
public abstract class MapItemMixin {
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")})
    private void appendHoverText(ItemStack stack, Level level, List<Component> tooltips, TooltipFlag tooltipFlag, CallbackInfo ci) {
        MapItemSavedData mapData;
        Integer integer = MapItem.m_151131_((ItemStack)stack);
        MapItemSavedData mapItemSavedData = mapData = level == null ? null : MapItem.m_151128_((Integer)integer, (Level)level);
        if (mapData instanceof ExpandedMapData) {
            ExpandedMapData data = (ExpandedMapData)mapData;
            data.getCustomData().forEach((s, o) -> {
                Component c = o.getTooltip(mapData, stack);
                if (c != null) {
                    tooltips.add(c);
                }
            });
        }
    }

    @Inject(method={"update"}, at={@At(value="HEAD")}, cancellable=true)
    private void update(Level level, Entity entity, MapItemSavedData data, CallbackInfo ci) {
        AtomicBoolean b = new AtomicBoolean(false);
        if (data instanceof ExpandedMapData) {
            ExpandedMapData d = (ExpandedMapData)data;
            d.getCustomData().forEach((s, o) -> b.set(o.onUpdate(data, entity)));
        }
        if (b.get()) {
            ci.cancel();
        }
    }
}

