/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.GuiFocusControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiTextfield
extends GuiFocusControl {
    private String text = "";
    private int maxStringLength = 128;
    private int frame;
    private boolean shift;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private String suggestion;
    private Predicate<String> validator = Objects::nonNull;
    private BiFunction<String, Integer, FormattedCharSequence> textFormatter = (text, pos) -> FormattedCharSequence.m_13714_((String)text, (Style)Style.f_131099_);
    private int cachedWidth;

    public GuiTextfield(String name) {
        super(name);
        this.setText("");
    }

    public GuiTextfield(String name, String text2) {
        super(name);
        this.setText(text2);
    }

    public GuiTextfield(String name, int width) {
        this(name, width, 20);
    }

    public GuiTextfield(String name, int width, int height) {
        this(name, "", width, height);
    }

    public GuiTextfield(String name, String text2, int width, int height) {
        super(name, width, height);
        this.setText(text2);
    }

    public GuiTextfield setFloatOnly() {
        this.validator = x -> {
            if (x.isEmpty()) {
                return true;
            }
            try {
                Float.parseFloat(x);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return this;
    }

    public GuiTextfield setNumbersIncludingNegativeOnly() {
        this.validator = x -> {
            if (x.isEmpty()) {
                return true;
            }
            try {
                Integer.parseInt(x);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return this;
    }

    public GuiTextfield setNumbersOnly() {
        this.validator = x -> {
            if (x.isEmpty()) {
                return true;
            }
            try {
                return Integer.parseInt(x) >= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return this;
    }

    public float parseFloat() {
        try {
            return Float.parseFloat(this.text);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public int parseInteger() {
        try {
            return Integer.parseInt(this.text);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
        ++this.frame;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack matrix, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        Font fontRenderer = GuiRenderHelper.getFont();
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        GuiStyle style = this.getStyle();
        int color = this.enabled ? style.fontColor.toInt() : style.fontColorDisabled.toInt();
        String s = fontRenderer.m_92834_(this.text.substring(this.lineScrollOffset), (int)rect.getWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.isFocused() && this.frame / 6 % 2 == 0 && flag;
        int yOffset = 0;
        int xOffset = 0;
        if (k > s.length()) {
            k = s.length();
        }
        if (!s.isEmpty()) {
            String s1 = flag ? s.substring(0, j) : s;
            xOffset = fontRenderer.m_92877_(matrix, this.textFormatter.apply(s1, this.lineScrollOffset), (float)xOffset, (float)yOffset, color) + 1;
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
        int k1 = xOffset;
        if (!flag) {
            k1 = j > 0 ? control.getWidth() : 0;
        } else if (flag2) {
            k1 = xOffset - 1;
            --xOffset;
        }
        if (!s.isEmpty() && flag && j < s.length()) {
            fontRenderer.m_92877_(matrix, this.textFormatter.apply(s.substring(j), this.cursorPosition), (float)xOffset, (float)yOffset, color);
        }
        if (!flag2 && this.suggestion != null) {
            fontRenderer.m_92750_(matrix, this.suggestion, (float)(k1 - 1), (float)yOffset, -8355712);
        }
        if (flag1) {
            if (flag2) {
                GuiComponent.m_93172_((PoseStack)matrix, (int)k1, (int)(yOffset - 1), (int)(k1 + 1), (int)(yOffset + 1 + 9), (int)-3092272);
            } else {
                fontRenderer.m_92750_(matrix, "_", (float)k1, (float)yOffset, color);
            }
        }
        if (k != j) {
            int l1 = fontRenderer.m_92895_(s.substring(0, k));
            this.drawSelectionBox(control, matrix.m_85850_().m_252922_(), k1, yOffset - 1, l1 - 1, yOffset + 1 + 9);
        }
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionZero();
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(textIn);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(i, j);
    }

    public void setValidator(Predicate<String> validatorIn) {
        this.validator = validatorIn;
    }

    public void writeText(String textToWrite) {
        String s1;
        String s;
        int l;
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (k < (l = (s = SharedConstants.m_136190_((String)textToWrite)).length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (this.validator.test(s1 = new StringBuilder(this.text).replace(i, j, s).toString())) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    private void onTextChanged(String newText) {
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    private void delete(int p_212950_1_) {
        if (Screen.m_96637_()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
        this.onTextChanged(this.text);
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                String s;
                int k;
                int i = this.getCursorPos(num);
                int j = Math.min(i, this.cursorPosition);
                if (j != (k = Math.max(i, this.cursorPosition)) && this.validator.test(s = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = s;
                    this.setCursorPosition(j);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.getCursorPos(num));
    }

    private int getCursorPos(int p_238516_1_) {
        return Util.m_137479_((String)this.text, (int)this.cursorPosition, (int)p_238516_1_);
    }

    public void setCursorPosition(int pos) {
        this.clampCursorPosition(pos);
        if (!this.shift) {
            this.setSelectionPos(this.cursorPosition);
        }
    }

    public void clampCursorPosition(int pos) {
        this.cursorPosition = Mth.m_14045_((int)pos, (int)0, (int)this.text.length());
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.canWrite()) {
            return false;
        }
        this.shift = Screen.m_96638_();
        if (Screen.m_96634_((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getSelectedText());
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            this.writeText(Minecraft.m_91087_().f_91068_.m_90876_());
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getSelectedText());
            this.writeText("");
            return true;
        }
        switch (keyCode) {
            case 259: {
                this.shift = false;
                this.delete(-1);
                this.shift = Screen.m_96638_();
                return true;
            }
            case 258: 
            case 260: 
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                return false;
            }
            default: {
                return SharedConstants.m_136188_((char)((char)keyCode));
            }
            case 261: {
                this.shift = false;
                this.delete(1);
                this.shift = Screen.m_96638_();
                return true;
            }
            case 262: {
                if (Screen.m_96637_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.m_96637_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean canWrite() {
        return this.isFocused();
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        if (!this.canWrite()) {
            return false;
        }
        if (SharedConstants.m_136188_((char)codePoint)) {
            this.writeText(Character.toString(codePoint));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(Rect rect, double mouseX, double mouseY, int button) {
        super.mouseClicked(rect, mouseX, mouseY, button);
        if (button == 0) {
            int i = Mth.m_14107_((double)mouseX);
            Font fontRenderer = GuiRenderHelper.getFont();
            String s = fontRenderer.m_92834_(this.text.substring(this.lineScrollOffset), (int)rect.getWidth());
            this.shift = Screen.m_96638_();
            this.setCursorPosition(fontRenderer.m_92834_(s, i).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    private void drawSelectionBox(GuiChildControl control, Matrix4f matrix, int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if ((double)endX > control.rect.maxX) {
            endX = (int)control.rect.maxX;
        }
        if ((double)startX > control.rect.maxX) {
            startX = (int)control.rect.maxX;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferbuilder.m_252986_(matrix, (float)startX, (float)endY, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)endX, (float)endY, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)endX, (float)startY, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)startX, (float)startY, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.onTextChanged(this.text);
        }
    }

    private int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    protected void focusChanged() {
        if (this.isFocused()) {
            this.frame = 0;
        }
    }

    @Override
    public void flowX(int width, int preferred) {
        this.cachedWidth = width - this.getContentOffset() * 2;
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredHeight(int width) {
        return 10;
    }

    @Override
    protected int preferredWidth() {
        return 40;
    }

    public void setSelectionPos(int position) {
        int textLength = this.text.length();
        this.selectionEnd = Mth.m_14045_((int)position, (int)0, (int)textLength);
        if (this.getParent() == null || !this.hasLayer()) {
            return;
        }
        Font fontRenderer = GuiRenderHelper.getFont();
        if (fontRenderer != null) {
            if (this.lineScrollOffset > textLength) {
                this.lineScrollOffset = textLength;
            }
            int j = this.cachedWidth;
            String s = fontRenderer.m_92834_(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= fontRenderer.m_92837_(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = Mth.m_14045_((int)this.lineScrollOffset, (int)0, (int)textLength);
        }
    }

    public void setSuggestion(@Nullable String p_195612_1_) {
        this.suggestion = p_195612_1_;
    }
}

