/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.base;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.geo.NormalPlane;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Facing {
    DOWN(Axis.Y, false, new Vec3i(0, -1, 0), -1){

        @Override
        public Facing opposite() {
            return UP;
        }

        @Override
        public Direction toVanilla() {
            return Direction.DOWN;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82289_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252392_;
        }
    }
    ,
    UP(Axis.Y, true, new Vec3i(0, 1, 0), -1){

        @Override
        public Facing opposite() {
            return DOWN;
        }

        @Override
        public Direction toVanilla() {
            return Direction.UP;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82292_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252436_;
        }
    }
    ,
    NORTH(Axis.Z, false, new Vec3i(0, 0, -1), 2){

        @Override
        public Facing opposite() {
            return SOUTH;
        }

        @Override
        public Direction toVanilla() {
            return Direction.NORTH;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82290_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252393_;
        }
    }
    ,
    SOUTH(Axis.Z, true, new Vec3i(0, 0, 1), 0){

        @Override
        public Facing opposite() {
            return NORTH;
        }

        @Override
        public Direction toVanilla() {
            return Direction.SOUTH;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82293_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252403_;
        }
    }
    ,
    WEST(Axis.X, false, new Vec3i(-1, 0, 0), 1){

        @Override
        public Facing opposite() {
            return EAST;
        }

        @Override
        public Direction toVanilla() {
            return Direction.WEST;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82288_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252495_;
        }
    }
    ,
    EAST(Axis.X, true, new Vec3i(1, 0, 0), 3){

        @Override
        public Facing opposite() {
            return WEST;
        }

        @Override
        public Direction toVanilla() {
            return Direction.EAST;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82291_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252529_;
        }
    };

    public static final Facing[] VALUES;
    public static final Facing[] HORIZONTA_VALUES;
    public static final String[] FACING_NAMES;
    public static final String[] HORIZONTAL_FACING_NAMES;
    public final String name = this.name().toLowerCase();
    public final Axis axis;
    public final boolean positive;
    public final Vec3i normal;
    public final NormalPlane plane;
    public final int horizontalIndex;

    public static Facing get(int index) {
        switch (index) {
            case 0: {
                return DOWN;
            }
            case 1: {
                return UP;
            }
            case 2: {
                return NORTH;
            }
            case 3: {
                return SOUTH;
            }
            case 4: {
                return WEST;
            }
            case 5: {
                return EAST;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Facing get(Direction direction) {
        if (direction == null) {
            return null;
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    public static Facing get(Axis axis, boolean positive) {
        switch (axis) {
            case X: {
                return positive ? EAST : WEST;
            }
            case Y: {
                return positive ? UP : DOWN;
            }
            case Z: {
                return positive ? SOUTH : NORTH;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Facing getHorizontal(int index) {
        return HORIZONTA_VALUES[index];
    }

    public static Facing direction(Vec3i pos, Vec3i second) {
        if (pos.m_123341_() == second.m_123341_()) {
            if (pos.m_123342_() == second.m_123342_()) {
                if (pos.m_123343_() == second.m_123343_() + 1) {
                    return SOUTH;
                }
                return NORTH;
            }
            if (pos.m_123342_() == second.m_123342_() + 1) {
                return UP;
            }
            return DOWN;
        }
        if (pos.m_123341_() == second.m_123341_() + 1) {
            return EAST;
        }
        return WEST;
    }

    private Facing(Axis axis, boolean positive, Vec3i normal, int horizontalIndex) {
        this.axis = axis;
        this.positive = positive;
        this.normal = normal;
        this.plane = new NormalPlane(this);
        this.horizontalIndex = horizontalIndex;
    }

    public int offset() {
        return this.positive ? 1 : -1;
    }

    public int offset(Axis axis) {
        if (this.axis == axis) {
            return this.offset();
        }
        return 0;
    }

    public abstract Facing opposite();

    public abstract Direction toVanilla();

    public Axis one() {
        return this.axis.one();
    }

    public Axis two() {
        return this.axis.two();
    }

    public Axis getUAxis() {
        switch (this.axis) {
            case X: {
                return Axis.Z;
            }
            case Y: {
                return Axis.X;
            }
            case Z: {
                return Axis.X;
            }
        }
        return null;
    }

    public Axis getVAxis() {
        switch (this.axis) {
            case X: {
                return Axis.Y;
            }
            case Y: {
                return Axis.Z;
            }
            case Z: {
                return Axis.Y;
            }
        }
        return null;
    }

    public float getU(float x, float y, float z) {
        switch (this.axis) {
            case X: {
                return z;
            }
            case Y: {
                return x;
            }
            case Z: {
                return x;
            }
        }
        return 0.0f;
    }

    public float getV(float x, float y, float z) {
        switch (this.axis) {
            case X: {
                return y;
            }
            case Y: {
                return z;
            }
            case Z: {
                return y;
            }
        }
        return 0.0f;
    }

    public abstract double get(AABB var1);

    public abstract com.mojang.math.Axis rotation();

    static {
        VALUES = new Facing[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        HORIZONTA_VALUES = new Facing[]{SOUTH, WEST, NORTH, EAST};
        FACING_NAMES = new String[]{"down", "up", "north", "south", "west", "east"};
        HORIZONTAL_FACING_NAMES = new String[]{"north", "south", "west", "east"};
    }
}

