/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import mezz.jei.common.config.ConfigManager;
import mezz.jei.common.config.file.ConfigCategory;
import mezz.jei.common.config.file.ConfigCategoryBuilder;
import mezz.jei.common.config.file.ConfigSerializer;
import mezz.jei.common.config.file.FileWatcher;
import mezz.jei.common.config.file.IConfigSchema;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ConfigSchema
implements IConfigSchema {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration SAVE_DELAY_TIME = Duration.ofSeconds(2L);
    private static final Timer SAVE_DELAY_TIMER = new Timer("JEI Config Save Delay");
    private final Path path;
    private final @Unmodifiable List<ConfigCategory> categories;
    private final AtomicBoolean needsLoad = new AtomicBoolean(true);
    @Nullable
    private TimerTask saveTask;

    public ConfigSchema(Path path, List<ConfigCategoryBuilder> categoryBuilders) {
        this.path = path;
        this.categories = categoryBuilders.stream().map(b -> b.build(this)).toList();
        ConfigManager.INSTANCE.registerConfigFile(this);
    }

    @Override
    public void loadIfNeeded() {
        if (!this.needsLoad.compareAndSet(true, false)) {
            return;
        }
        if (Files.exists(this.path, new LinkOption[0])) {
            try {
                ConfigSerializer.load(this.path, this.categories);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config schema for: %s".formatted(this.path), (Throwable)e);
            }
        }
    }

    private void onFileChanged() {
        this.needsLoad.set(true);
    }

    @Override
    public void register() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            this.save();
        }
        try {
            Map<Path, Runnable> callbacks = Map.of(this.path, this::onFileChanged);
            FileWatcher fileWatcher = new FileWatcher(callbacks);
            Thread thread = new Thread(fileWatcher::run, "JEI Config file watcher");
            thread.start();
        }
        catch (IOException e) {
            LOGGER.error("Failed to create FileWatcher Thread for config file: '{}'", (Object)this.path, (Object)e);
        }
    }

    private void save() {
        try {
            ConfigSerializer.save(this.path, this.categories);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config file: '{}'", (Object)this.path, (Object)e);
        }
    }

    @Override
    public void markDirty() {
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
        this.saveTask = new TimerTask(){

            @Override
            public void run() {
                ConfigSchema.this.save();
                ConfigSchema.this.saveTask = null;
            }
        };
        SAVE_DELAY_TIMER.schedule(this.saveTask, SAVE_DELAY_TIME.toMillis());
    }

    public @Unmodifiable List<ConfigCategory> getCategories() {
        return this.categories;
    }

    @Override
    public Path getPath() {
        return this.path;
    }
}

