/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients;

import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IEditModeConfig;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.Constants;
import mezz.jei.common.config.IWorldConfig;
import mezz.jei.core.util.WeakList;
import mezz.jei.library.config.EditModeConfig;
import mezz.jei.library.ingredients.IngredientBlacklistInternal;
import mezz.jei.library.ingredients.TypedIngredient;
import net.minecraft.resources.ResourceLocation;

public class IngredientVisibility
implements IIngredientVisibility {
    private final IngredientBlacklistInternal blacklist;
    private final IWorldConfig worldConfig;
    private final IEditModeConfig editModeConfig;
    private final IIngredientManager ingredientManager;
    private final WeakList<IIngredientVisibility.IListener> listeners = new WeakList();

    public IngredientVisibility(IngredientBlacklistInternal blacklist, IWorldConfig worldConfig, EditModeConfig editModeConfig, IIngredientManager ingredientManager) {
        this.blacklist = blacklist;
        this.worldConfig = worldConfig;
        this.editModeConfig = editModeConfig;
        this.ingredientManager = ingredientManager;
        blacklist.registerListener(this::notifyListenersOfVisibilityChange);
        editModeConfig.registerListener(this::notifyListenersOfVisibilityChange);
    }

    @Override
    public <V> boolean isIngredientVisible(ITypedIngredient<V> typedIngredient) {
        IIngredientType<V> ingredientType = typedIngredient.getType();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
        return this.isIngredientVisible(typedIngredient, ingredientHelper);
    }

    @Override
    public <V> boolean isIngredientVisible(IIngredientType<V> ingredientType, V ingredient) {
        IIngredientHelper ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
        return TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredientType, ingredient).map(i -> this.isIngredientVisible((ITypedIngredient)i, ingredientHelper)).orElse(false);
    }

    public <V> boolean isIngredientVisible(ITypedIngredient<V> typedIngredient, IIngredientHelper<V> ingredientHelper) {
        if (this.blacklist.isIngredientBlacklistedByApi(typedIngredient, ingredientHelper)) {
            return false;
        }
        if (!ingredientHelper.isIngredientOnServer(typedIngredient.getIngredient())) {
            return false;
        }
        Stream<ResourceLocation> tags = ingredientHelper.getTagStream(typedIngredient.getIngredient());
        if (tags.anyMatch(arg_0 -> ((ResourceLocation)Constants.HIDDEN_INGREDIENT_TAG).equals(arg_0))) {
            return false;
        }
        return this.worldConfig.isEditModeEnabled() || !this.editModeConfig.isIngredientHiddenUsingConfigFile(typedIngredient);
    }

    @Override
    public void registerListener(IIngredientVisibility.IListener listener) {
        this.listeners.add(listener);
    }

    private <T> void notifyListenersOfVisibilityChange(ITypedIngredient<T> ingredient, boolean visible) {
        this.listeners.forEach(listener -> listener.onIngredientVisibilityChanged(ingredient, visible));
    }
}

