/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void render(PoseStack poseStack, @Nullable ItemStack ingredient) {
        if (ingredient != null) {
            PoseStack modelViewStack = RenderSystem.m_157191_();
            modelViewStack.m_85836_();
            modelViewStack.m_252931_(poseStack.m_85850_().m_252922_());
            RenderSystem.m_69482_();
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = this.getFontRenderer(minecraft, ingredient);
            ItemRenderer itemRenderer = minecraft.m_91291_();
            itemRenderer.m_115218_(ingredient, 0, 0);
            itemRenderer.m_115169_(font, ingredient, 0, 0);
            RenderSystem.m_69461_();
            modelViewStack.m_85849_();
            RenderSystem.m_157182_();
        }
    }

    @Override
    public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        try {
            return ingredient.m_41651_((Player)player, tooltipFlag);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(ingredient);
            LOGGER.error("Failed to get tooltip: {}", (Object)itemStackInfo, (Object)e);
            ArrayList<Component> list = new ArrayList<Component>();
            MutableComponent crash = Component.m_237115_((String)"jei.tooltip.error.crash");
            list.add((Component)crash.m_130940_(ChatFormatting.RED));
            return list;
        }
    }

    @Override
    public Font getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        return renderHelper.getFontRenderer(minecraft, ingredient);
    }

    @Override
    public int getWidth() {
        return 16;
    }

    @Override
    public int getHeight() {
        return 16;
    }
}

