/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.inv;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotMenu;
import net.darkhax.botanypots.block.inv.SlotCropSeed;
import net.darkhax.botanypots.block.inv.SlotSoil;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BotanyPotScreen
extends AbstractContainerScreen<BotanyPotMenu> {
    private static final NumberFormat MULTIPLIER_FORMAT = new DecimalFormat("##.##");
    private static final Component NEW_LINE = Component.m_237113_((String)"");
    private static final Component TOOLTIP_INVALID_SOIL = Component.m_237115_((String)"tooltip.botanypots.invalid_soil").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_INVALID_CROP = Component.m_237115_((String)"tooltip.botanypots.invalid_seed").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_INCORRECT_SOIL = Component.m_237115_((String)"tooltip.botanypots.incorrect_soil").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_INCORRECT_SEED = Component.m_237115_((String)"tooltip.botanypots.incorrect_seed").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_MISSING_SOIL = Component.m_237115_((String)"tooltip.botanypots.missing_soil").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_MISSING_SEED = Component.m_237115_((String)"tooltip.botanypots.missing_seed").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_SOIL_ITEM = Component.m_237115_((String)"tooltip.botanypots.soil_item").m_130940_(ChatFormatting.GREEN);
    private static final Component TOOLTIP_SEED_ITEM = Component.m_237115_((String)"tooltip.botanypots.seed_item").m_130940_(ChatFormatting.GREEN);
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = new ResourceLocation("textures/gui/recipe_button.png");
    private final ResourceLocation backgroundTexture;

    public BotanyPotScreen(BotanyPotMenu menu, Inventory playerInv, Component name) {
        super((AbstractContainerMenu)menu, playerInv, name);
        this.backgroundTexture = new ResourceLocation("botanypots", "textures/gui/container/" + (menu.isHopper() ? "hopper_botany_pot_gui.png" : "botany_pot_gui.png"));
    }

    public void m_7856_() {
        super.m_7856_();
        int recipeOffset = this.f_97735_ + (((BotanyPotMenu)this.f_97732_).isHopper() ? 13 : 33);
        this.m_142416_((GuiEventListener)new ImageButton(recipeOffset, this.f_96544_ / 2 - 49, 20, 18, 0, 0, 19, RECIPE_BUTTON_LOCATION, btn -> {}));
    }

    protected void m_7286_(PoseStack poseStack, float v, int i, int i1) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.backgroundTexture);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float tickDelta) {
        this.m_7333_(poseStack);
        super.m_86412_(poseStack, mouseX, mouseY, tickDelta);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    public List<Component> m_96555_(ItemStack stack) {
        List tooltips = super.m_96555_(stack);
        if (this.f_96541_ != null) {
            boolean isAdvanced = this.f_96541_.f_91066_.f_92125_;
            LocalPlayer player = this.f_96541_.f_91074_;
            BlockEntityBotanyPot pot = ((BotanyPotMenu)this.f_97732_).getPotInventory().getPotEntity();
            Level level = pot.m_58904_();
            BlockPos pos = pot.m_58899_();
            Slot slot = this.f_97734_;
            if (slot instanceof SlotSoil) {
                SlotSoil soilSlot = (SlotSoil)slot;
                if (!pot.isValidSoil(stack)) {
                    tooltips.add(TOOLTIP_INVALID_SOIL);
                } else {
                    soil = BotanyPotHelper.findSoil(level, pos, pot, stack);
                    if (soil != null) {
                        if (pot.getCrop() == null) {
                            tooltips.add(TOOLTIP_MISSING_SEED);
                        } else if (!BotanyPotHelper.canCropGrow(level, pos, pot, (Soil)((Object)soil), pot.getCrop())) {
                            tooltips.add(TOOLTIP_INCORRECT_SOIL);
                        } else {
                            float growthModifier = soil.getGrowthModifier(level, pos, pot, pot.getCrop());
                            MutableComponent multiplier = Component.m_237113_((String)MULTIPLIER_FORMAT.format(growthModifier)).m_130940_(growthModifier > 1.0f ? ChatFormatting.GREEN : (growthModifier < 1.0f ? ChatFormatting.RED : ChatFormatting.GRAY));
                            tooltips.add(Component.m_237110_((String)"tooltip.botanypots.soil_modifier", (Object[])new Object[]{multiplier}).m_130940_(ChatFormatting.GRAY));
                        }
                    }
                }
            } else {
                soil = this.f_97734_;
                if (soil instanceof SlotCropSeed) {
                    Crop crop;
                    SlotCropSeed seedSlot = (SlotCropSeed)((Object)soil);
                    if (!pot.isValidSeed(stack)) {
                        tooltips.add(TOOLTIP_INVALID_CROP);
                    }
                    if ((crop = BotanyPotHelper.findCrop(level, pos, pot, stack)) != null) {
                        if (pot.getSoil() == null) {
                            tooltips.add(TOOLTIP_MISSING_SOIL);
                        } else if (!BotanyPotHelper.canCropGrow(level, pos, pot, pot.getSoil(), crop)) {
                            tooltips.add(TOOLTIP_INCORRECT_SEED);
                        }
                    }
                } else {
                    Crop hoveredCrop;
                    Soil hoverSoil = BotanyPotHelper.findSoil(level, pos, pot, stack);
                    if (hoverSoil != null) {
                        tooltips.add(TOOLTIP_SOIL_ITEM);
                        if (isAdvanced) {
                            tooltips.add(Component.m_237110_((String)"tooltip.botanypots.soil_id", (Object[])new Object[]{hoverSoil.m_6423_().toString()}).m_130940_(ChatFormatting.GRAY));
                        }
                    }
                    if ((hoveredCrop = BotanyPotHelper.findCrop(level, pos, pot, stack)) != null) {
                        tooltips.add(TOOLTIP_SEED_ITEM);
                        if (isAdvanced) {
                            tooltips.add(Component.m_237110_((String)"tooltip.botanypots.crop_id", (Object[])new Object[]{hoveredCrop.m_6423_().toString()}).m_130940_(ChatFormatting.GRAY));
                        }
                    }
                }
            }
        }
        return tooltips;
    }
}

