/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.PlayerVolumeEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class GroupEntry
extends ListScreenEntryBase<GroupEntry> {
    protected static final ResourceLocation TALK_OUTLINE = new ResourceLocation("voicechat", "textures/icons/talk_outline.png");
    protected static final ResourceLocation SPEAKER_OFF = new ResourceLocation("voicechat", "textures/icons/speaker_small_off.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = FastColor.ARGB32.m_13660_((int)255, (int)74, (int)74, (int)74);
    protected static final int PLAYER_NAME_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    protected final ListScreenBase parent;
    protected final Minecraft minecraft;
    protected PlayerState state;
    protected final AdjustVolumeSlider volumeSlider;

    public GroupEntry(ListScreenBase parent, PlayerState state) {
        this.parent = parent;
        this.minecraft = Minecraft.m_91087_();
        this.state = state;
        this.volumeSlider = new AdjustVolumeSlider(0, 0, 100, 20, new PlayerVolumeEntry.PlayerVolumeConfigEntry(state.getUuid()));
        this.children.add(this.volumeSlider);
    }

    public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        ClientVoicechat client;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL);
        poseStack.m_85836_();
        int outlineSize = height - 8;
        poseStack.m_85837_((double)(left + 4), (double)(top + 4), 0.0);
        float scale = (float)outlineSize / 10.0f;
        poseStack.m_85841_(scale, scale, scale);
        if (!this.state.isDisabled() && (client = ClientManager.getClient()) != null && client.getTalkCache().isTalking(this.state.getUuid())) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TALK_OUTLINE);
            Screen.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)10, (int)10, (int)16, (int)16);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GameProfileUtils.getSkin(this.state.getUuid()));
        GuiComponent.m_93160_((PoseStack)poseStack, (int)1, (int)1, (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        RenderSystem.m_69478_();
        GuiComponent.m_93160_((PoseStack)poseStack, (int)1, (int)1, (int)8, (int)8, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        RenderSystem.m_69461_();
        if (this.state.isDisabled()) {
            poseStack.m_85836_();
            poseStack.m_85837_(1.0, 1.0, 0.0);
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)SPEAKER_OFF);
            Screen.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        MutableComponent name = Component.m_237113_((String)this.state.getName());
        Font font = this.minecraft.f_91062_;
        float f = left + 4 + outlineSize + 4;
        int n = top + height / 2;
        Objects.requireNonNull(this.minecraft.f_91062_);
        font.m_92889_(poseStack, (Component)name, f, (float)(n - 9 / 2), PLAYER_NAME_COLOR);
        if (hovered && !ClientManager.getPlayerStateManager().getOwnID().equals(this.state.getUuid())) {
            this.volumeSlider.m_93674_(Math.min(width - (4 + outlineSize + 4 + this.minecraft.f_91062_.m_92852_((FormattedText)name) + 4 + 4), 100));
            this.volumeSlider.m_252846_(left + (width - this.volumeSlider.m_5711_() - 4), top + (height - this.volumeSlider.m_93694_()) / 2);
            this.volumeSlider.m_86412_(poseStack, mouseX, mouseY, delta);
        }
    }

    public PlayerState getState() {
        return this.state;
    }

    public void setState(PlayerState state) {
        this.state = state;
    }
}

