/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet.client;

import com.legacy.mining_helmet.MiningHelmetConfig;
import com.legacy.mining_helmet.MiningHelmetMod;
import com.legacy.mining_helmet.MiningHelmetRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DynamicLightingManager {
    private static final Minecraft MC = Minecraft.m_91087_();
    public static final Map<BlockPos, LightData> SOURCES = new ConcurrentHashMap<BlockPos, LightData>();

    public static void tick() {
        if (MiningHelmetMod.lucentPresent()) {
            return;
        }
        if (DynamicLightingManager.MC.f_91074_ != null && DynamicLightingManager.MC.f_91073_ != null && DynamicLightingManager.MC.f_91074_.f_19797_ % MiningHelmetConfig.lightRefreshRate() == 0) {
            SOURCES.forEach((blockPos, data) -> {
                data.shouldStay = false;
            });
            DynamicLightingManager.MC.f_91073_.m_6443_(LivingEntity.class, DynamicLightingManager.MC.f_91074_.m_20191_().m_82400_((double)MiningHelmetConfig.maxVisibleDistance()), DynamicLightingManager::shouldGlow).forEach(e -> SOURCES.put(e.m_20183_().m_6630_((int)e.m_20192_()), new LightData()));
            if (!SOURCES.isEmpty()) {
                SOURCES.forEach((blockPos, data) -> DynamicLightingManager.MC.f_91073_.m_7726_().m_7827_().m_7174_(blockPos));
                SOURCES.entrySet().removeIf(entry -> !((LightData)entry.getValue()).shouldStay);
            }
        }
    }

    public static boolean shouldGlow(LivingEntity entity) {
        if (MiningHelmetMod.lucentPresent()) {
            return false;
        }
        if (entity.m_6844_(EquipmentSlot.HEAD).m_41720_() == MiningHelmetRegistry.MINING_HELMET.get()) {
            boolean visible = MiningHelmetConfig.seeThroughWalls();
            if (!visible) {
                boolean bl = visible = DynamicLightingManager.MC.f_91074_.f_19853_.m_45547_(new ClipContext(DynamicLightingManager.MC.f_91074_.m_20182_(), entity.m_146892_(), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)entity)).m_6662_() == HitResult.Type.MISS;
                if (!visible && DynamicLightingManager.MC.f_91074_.m_20270_((Entity)entity) < 24.0f) {
                    visible = true;
                }
            }
            return visible;
        }
        return false;
    }

    public static void cleanUp() {
        if (MiningHelmetMod.lucentPresent()) {
            return;
        }
        if (SOURCES.size() > 0 && DynamicLightingManager.MC.f_91073_ != null) {
            MiningHelmetMod.LOGGER.info(String.format("Cleaning up light data for %s light sources", SOURCES.size()));
            SOURCES.forEach((blockPos, data) -> {
                data.shouldStay = false;
                DynamicLightingManager.MC.f_91073_.m_7726_().m_7827_().m_7174_(blockPos);
            });
            SOURCES.clear();
        }
    }

    public static class LightData {
        public boolean shouldStay = true;
    }
}

