/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.screen.ContainerScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.balm.mixin.SlotAccessor;
import net.blay09.mods.trashslot.PlatformBindings;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.TrashSlotSaveState;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.client.ContainerSettings;
import net.blay09.mods.trashslot.client.LayoutManager;
import net.blay09.mods.trashslot.client.ModKeyMappings;
import net.blay09.mods.trashslot.client.TrashSlotSlot;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.blay09.mods.trashslot.client.gui.TrashSlotComponent;
import net.blay09.mods.trashslot.config.TrashSlotConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TrashSlotGuiHandler {
    private static final TrashSlotSlot trashSlot = new TrashSlotSlot();
    private static TrashSlotComponent trashSlotComponent;
    private static ContainerSettings currentContainerSettings;
    private static boolean ignoreMouseUp;
    private static boolean sentMissingMessage;
    private static long missingMessageTime;
    private static boolean isLeftMouseDown;

    public static void initialize() {
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, TrashSlotGuiHandler::onScreenInit);
        Balm.getEvents().onEvent(ScreenMouseEvent.Release.Pre.class, TrashSlotGuiHandler::onMouseRelease);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, TrashSlotGuiHandler::onMouseClick);
        Balm.getEvents().onEvent(ScreenKeyEvent.Press.Post.class, TrashSlotGuiHandler::onKeyPress);
        Balm.getEvents().onEvent(ContainerScreenDrawEvent.Background.class, TrashSlotGuiHandler::onBackgroundDrawn);
        Balm.getEvents().onEvent(ContainerScreenDrawEvent.Background.class, TrashSlotGuiHandler::onScreenDrawn);
    }

    private static void onScreenInit(ScreenInitEvent.Post event) {
        if (event.getScreen() instanceof CreativeModeInventoryScreen) {
            currentContainerSettings = ContainerSettings.NONE;
            trashSlotComponent = null;
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (!TrashSlot.isServerSideInstalled && !sentMissingMessage) {
                TrashSlot.logger.info("TrashSlot is not installed on the server and thus will be unavailable.");
                missingMessageTime = System.currentTimeMillis();
                sentMissingMessage = true;
                return;
            }
            if (screen2 instanceof InventoryScreen && Minecraft.m_91087_().f_91074_.m_150110_().f_35937_) {
                return;
            }
            IGuiContainerLayout layout = LayoutManager.getLayout(screen2);
            currentContainerSettings = TrashSlotSaveState.getSettings(screen2, layout);
            trashSlotComponent = currentContainerSettings != ContainerSettings.NONE ? new TrashSlotComponent(screen2, layout, currentContainerSettings, trashSlot) : null;
        } else {
            currentContainerSettings = ContainerSettings.NONE;
            trashSlotComponent = null;
        }
    }

    private static void onMouseRelease(ScreenMouseEvent.Release.Pre event) {
        if (event.getButton() == 0) {
            isLeftMouseDown = false;
        }
        if (ignoreMouseUp) {
            event.setCanceled(true);
            ignoreMouseUp = false;
        }
    }

    private static void onMouseClick(ScreenMouseEvent.Click.Pre event) {
        DeletionProvider deletionProvider;
        if (event.getButton() == 0) {
            isLeftMouseDown = true;
        }
        if ((deletionProvider = TrashSlotConfig.getDeletionProvider()) == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        int mouseButton = event.getButton();
        if (TrashSlotGuiHandler.runKeyBindings(event.getScreen(), InputConstants.Type.MOUSE, mouseButton, 0)) {
            event.setCanceled(true);
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            double mouseY;
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            double mouseX = event.getMouseX();
            if (((AbstractContainerScreenAccessor)screen2).callIsHovering((Slot)trashSlot, mouseX, mouseY = event.getMouseY())) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    boolean isRightClick;
                    ItemStack mouseItem = screen2.m_6262_().m_142621_();
                    boolean bl = isRightClick = mouseButton == 1;
                    if (mouseItem.m_41619_()) {
                        deletionProvider.undeleteLast((Player)player, trashSlot, isRightClick);
                    } else {
                        deletionProvider.deleteMouseItem((Player)player, mouseItem, trashSlot, isRightClick);
                    }
                    event.setCanceled(true);
                    ignoreMouseUp = true;
                }
            } else if (trashSlotComponent.isInside((int)mouseX, (int)mouseY)) {
                event.setCanceled(true);
                ignoreMouseUp = true;
            }
        }
    }

    private static void onKeyPress(ScreenKeyEvent.Press.Post event) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return;
        }
        int keyCode = event.getKey();
        int scanCode = event.getScanCode();
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (TrashSlotGuiHandler.runKeyBindings(event.getScreen(), input.m_84868_(), keyCode, scanCode)) {
            event.setCanceled(true);
        }
    }

    private static boolean runKeyBindings(Screen screen, InputConstants.Type type, int keyCode, int scanCode) {
        Slot mouseSlot;
        CreativeModeInventoryScreen containerScreen;
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return false;
        }
        boolean isDelete = BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBindDelete, type, keyCode, scanCode);
        boolean isDeleteAll = BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBindDeleteAll, type, keyCode, scanCode);
        if (isDelete && isDeleteAll && !PlatformBindings.INSTANCE.supportsKeyModifiers()) {
            isDelete = !Screen.m_96638_();
            isDeleteAll = Screen.m_96638_();
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if ((isDelete || isDeleteAll) && TrashSlotConfig.getActive().enableDeleteKeysInCreative && screen instanceof CreativeModeInventoryScreen) {
            containerScreen = (CreativeModeInventoryScreen)screen;
            if (player != null) {
                mouseSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
                DeletionProvider creativeDeletionProvider = TrashSlotConfig.getCreativeDeletionProvider();
                if (mouseSlot != null && mouseSlot.getClass() == Slot.class) {
                    creativeDeletionProvider.deleteContainerItem(containerScreen.m_6262_(), mouseSlot.f_40219_ - 9, isDeleteAll, trashSlot);
                } else if (mouseSlot != null && mouseSlot.getClass().getSimpleName().equals("SlotWrapper")) {
                    creativeDeletionProvider.deleteContainerItem(containerScreen.m_6262_(), mouseSlot.m_150661_(), isDeleteAll, trashSlot);
                }
            }
        }
        if (currentContainerSettings.isEnabled() && (isDelete || isDeleteAll) && player != null && screen instanceof AbstractContainerScreen) {
            containerScreen = (AbstractContainerScreen)screen;
            mouseSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
            if (mouseSlot != null && mouseSlot.m_6657_()) {
                deletionProvider.deleteContainerItem(containerScreen.m_6262_(), mouseSlot.f_40219_, isDeleteAll, trashSlot);
            } else {
                double mouseY;
                Window mainWindow = Minecraft.m_91087_().m_91268_();
                double rawMouseX = Minecraft.m_91087_().f_91067_.m_91589_();
                double rawMouseY = Minecraft.m_91087_().f_91067_.m_91594_();
                double mouseX = rawMouseX * (double)mainWindow.m_85445_() / (double)mainWindow.m_85441_();
                if (((AbstractContainerScreenAccessor)containerScreen).callIsHovering((Slot)trashSlot, mouseX, mouseY = rawMouseY * (double)mainWindow.m_85446_() / (double)mainWindow.m_85442_())) {
                    deletionProvider.emptyTrashSlot(trashSlot);
                }
            }
            return true;
        }
        if (screen instanceof AbstractContainerScreen && currentContainerSettings != ContainerSettings.NONE && BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBindToggleSlot, type, keyCode, scanCode)) {
            currentContainerSettings.setEnabled(!currentContainerSettings.isEnabled());
            TrashSlotSaveState.save();
            return true;
        }
        return false;
    }

    public static void onBackgroundDrawn(ContainerScreenDrawEvent.Background event) {
        PoseStack poseStack = event.getPoseStack();
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (trashSlotComponent != null) {
                trashSlotComponent.update(event.getMouseX(), event.getMouseY());
                trashSlotComponent.drawBackground(poseStack);
                if (((AbstractContainerScreenAccessor)screen2).callIsHovering((Slot)trashSlot, (double)event.getMouseX(), (double)event.getMouseY())) {
                    poseStack.m_85836_();
                    poseStack.m_252880_((float)((AbstractContainerScreenAccessor)screen2).getLeftPos(), (float)((AbstractContainerScreenAccessor)screen2).getTopPos(), 0.0f);
                    AbstractContainerScreen.m_169606_((PoseStack)poseStack, (int)TrashSlotGuiHandler.trashSlot.f_40220_, (int)TrashSlotGuiHandler.trashSlot.f_40221_, (int)screen2.m_93252_());
                    poseStack.m_85849_();
                }
            }
        }
    }

    public static void onScreenDrawn(ContainerScreenDrawEvent.Background event) {
        DeletionProvider deletionProvider;
        Screen screen;
        PoseStack poseStack = event.getPoseStack();
        if (missingMessageTime != 0L && System.currentTimeMillis() - missingMessageTime < 3000L && (screen = event.getScreen()) instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            MutableComponent noHabloEspanol = Component.m_237115_((String)"trashslot.serverNotInstalled");
            noHabloEspanol.m_130940_(ChatFormatting.RED);
            screen2.m_96597_(poseStack, (List)Lists.newArrayList((Object[])new Component[]{noHabloEspanol}), ((AbstractContainerScreenAccessor)screen2).getLeftPos() + ((AbstractContainerScreenAccessor)screen2).getImageWidth() / 2 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)noHabloEspanol) / 2, 25);
        }
        if ((deletionProvider = TrashSlotConfig.getDeletionProvider()) == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        Screen screen3 = event.getScreen();
        if (screen3 instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen4 = (AbstractContainerScreen)screen3;
            if (trashSlotComponent != null) {
                TrashSlotSlot trashSlot = TrashSlotGuiHandler.trashSlot;
                SlotAccessor slotAccessor = (SlotAccessor)trashSlot;
                slotAccessor.setX(trashSlot.f_40220_ + ((AbstractContainerScreenAccessor)screen4).getLeftPos());
                slotAccessor.setY(trashSlot.f_40221_ + ((AbstractContainerScreenAccessor)screen4).getTopPos());
                ((AbstractContainerScreenAccessor)screen4).callRenderSlot(poseStack, (Slot)trashSlot);
                slotAccessor.setX(trashSlot.f_40220_ - ((AbstractContainerScreenAccessor)screen4).getLeftPos());
                slotAccessor.setY(trashSlot.f_40221_ - ((AbstractContainerScreenAccessor)screen4).getTopPos());
                boolean isMouseSlot = ((AbstractContainerScreenAccessor)screen4).callIsHovering((Slot)trashSlot, (double)event.getMouseX(), (double)event.getMouseY());
                if (isMouseSlot && screen4.m_6262_().m_142621_().m_41619_() && trashSlot.m_6657_()) {
                    screen4.m_96597_(poseStack, screen4.m_96555_(trashSlot.m_7993_()), event.getMouseX(), event.getMouseY());
                }
            }
        }
    }

    public static TrashSlotComponent getTrashSlotComponent() {
        return trashSlotComponent;
    }

    public static TrashSlotSlot getTrashSlot() {
        return trashSlot;
    }

    public static boolean isLeftMouseDown() {
        return isLeftMouseDown;
    }

    static {
        currentContainerSettings = ContainerSettings.NONE;
    }
}

