/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.blockentities;

import com.fizzware.dramaticdoors.DDTags;
import com.fizzware.dramaticdoors.blockentities.DDBlockEntities;
import com.fizzware.dramaticdoors.compat.Compats;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class TallNetheriteDoorBlockEntity
extends BlockEntity {
    public String password = null;

    public TallNetheriteDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DDBlockEntities.TALL_NETHERITE_DOOR.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.password != null) {
            tag.m_128359_("Password", this.password);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Password")) {
            this.password = tag.m_128461_("Password");
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPassword(ItemStack stack) {
        this.setPassword(stack.m_41786_().getString());
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public void clearOwner() {
        this.password = null;
    }

    public static boolean isCorrectKey(ItemStack key, String password) {
        return key.m_41786_().getString().equals(password);
    }

    public boolean isCorrectKey(ItemStack key) {
        return TallNetheriteDoorBlockEntity.isCorrectKey(key, this.password);
    }

    public static KeyStatus hasKeyInInventory(Player player, String key) {
        if (key == null) {
            return KeyStatus.CORRECT_KEY;
        }
        KeyStatus found = KeyStatus.INCORRECT_KEY;
        if (Compats.CURIOS_INSTALLED) {
            // empty if block
        }
        AtomicReference itemHandler = new AtomicReference();
        player.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(itemHandler::set);
        if (itemHandler.get() != null) {
            for (int _idx = 0; _idx < ((IItemHandler)itemHandler.get()).getSlots(); ++_idx) {
                ItemStack stack = ((IItemHandler)itemHandler.get()).getStackInSlot(_idx);
                if (!stack.m_204117_(DDTags.KEY)) continue;
                found = KeyStatus.INCORRECT_KEY;
                if (!TallNetheriteDoorBlockEntity.isCorrectKey(stack, key)) continue;
                return KeyStatus.CORRECT_KEY;
            }
        }
        return found;
    }

    public static boolean doesPlayerHaveKeyToOpen(Player player, String lockPassword, boolean feedbackMessage, @Nullable String translName) {
        KeyStatus key = TallNetheriteDoorBlockEntity.hasKeyInInventory(player, lockPassword);
        if (key == KeyStatus.INCORRECT_KEY) {
            if (feedbackMessage) {
                player.m_5661_((Component)Component.m_237115_((String)"message.supplementaries.safe.incorrect_key"), true);
            }
            return false;
        }
        if (key == KeyStatus.CORRECT_KEY) {
            return true;
        }
        if (feedbackMessage) {
            player.m_5661_((Component)Component.m_237115_((String)("message.supplementaries." + translName + ".locked")), true);
        }
        return false;
    }

    public boolean handleAction(Player player, InteractionHand handIn, String translName) {
        if (player.m_5833_()) {
            return false;
        }
        ItemStack stack = player.m_21120_(handIn);
        boolean isKey = stack.m_204117_(DDTags.KEY);
        if (player.m_6047_() && isKey && (player.m_7500_() || this.isCorrectKey(stack))) {
            this.clearOwner();
            player.m_5661_((Component)Component.m_237115_((String)"message.supplementaries.safe.cleared"), true);
            this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_12012_, SoundSource.BLOCKS, 0.5f, 1.5f);
            return false;
        }
        if (this.password == null) {
            if (isKey) {
                this.setPassword(stack);
                player.m_5661_((Component)Component.m_237110_((String)"message.supplementaries.safe.assigned_key", (Object[])new Object[]{this.password}), true);
                this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_12012_, SoundSource.BLOCKS, 0.5f, 1.5f);
                return false;
            }
            return true;
        }
        return player.m_7500_() || TallNetheriteDoorBlockEntity.doesPlayerHaveKeyToOpen(player, this.password, true, translName);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static enum KeyStatus {
        CORRECT_KEY,
        INCORRECT_KEY,
        NO_KEY;

    }
}

