/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.datagen;

import com.fizzware.dramaticdoors.blocks.DDBlocks;
import com.fizzware.dramaticdoors.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.state.properties.TripleBlockPart;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class DDBlockStateProvider
extends BlockStateProvider {
    public DDBlockStateProvider(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "dramaticdoors", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.tallDoorBlock((Block)DDBlocks.TALL_OAK_DOOR.get(), "block/tall_oak");
    }

    private void tallDoorBlock(Block block, String baseName) {
        this.internalTallDoorBlock((TallDoorBlock)block, baseName, new ResourceLocation("dramaticdoors", baseName + "_door_bottom"), new ResourceLocation("dramaticdoors", baseName + "_door_middle"), new ResourceLocation("dramaticdoors", baseName + "_door_top"));
    }

    private void internalTallDoorBlock(TallDoorBlock block, String baseName, ResourceLocation bottom, ResourceLocation middle, ResourceLocation top) {
        ModelBuilder bottomLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_left", "block/door_bottom_left")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder bottomLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_left_open", "block/door_bottom_left_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder bottomRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_right", "block/door_bottom_right")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder bottomRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_right_open", "block/door_bottom_right_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder middleLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_left", "dramaticdoors:block/door_middle_left")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder middleLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_left_open", "dramaticdoors:block/door_middle_left_open")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder middleRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_right", "dramaticdoors:block/door_middle_right")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder middleRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_right_open", "dramaticdoors:block/door_middle_right_open")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder topLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_left", "block/door_top_left")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder topLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_left_open", "block/door_top_left_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder topRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_right", "block/door_top_right")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder topRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_right_open", "block/door_top_right_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        this.tallDoorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)middleLeft, (ModelFile)middleLeftOpen, (ModelFile)middleRight, (ModelFile)middleRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
    }

    public void tallDoorBlock(TallDoorBlock block, ModelFile bottomLeft, ModelFile bottomLeftOpen, ModelFile bottomRight, ModelFile bottomRightOpen, ModelFile middleLeft, ModelFile middleLeftOpen, ModelFile middleRight, ModelFile middleRightOpen, ModelFile topLeft, ModelFile topLeftOpen, ModelFile topRight, ModelFile topRightOpen) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.m_61143_((Property)TallDoorBlock.FACING)).m_122435_() + 90;
            TripleBlockPart third = (TripleBlockPart)((Object)((Object)state.m_61143_(TallDoorBlock.THIRD)));
            boolean right = state.m_61143_(TallDoorBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)TallDoorBlock.OPEN);
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            yRot %= 360;
            ModelFile model = null;
            switch (third) {
                default: {
                    if (right && open) {
                        model = bottomRightOpen;
                    } else if (!right && open) {
                        model = bottomLeftOpen;
                    }
                    if (right && !open) {
                        model = bottomRight;
                        break;
                    }
                    if (right || open) break;
                    model = bottomLeft;
                    break;
                }
                case MIDDLE: {
                    if (right && open) {
                        model = middleRightOpen;
                    } else if (!right && open) {
                        model = middleLeftOpen;
                    }
                    if (right && !open) {
                        model = middleRight;
                        break;
                    }
                    if (right || open) break;
                    model = middleLeft;
                    break;
                }
                case UPPER: {
                    if (right && open) {
                        model = topRightOpen;
                    } else if (!right && open) {
                        model = topLeftOpen;
                    }
                    if (right && !open) {
                        model = topRight;
                        break;
                    }
                    if (right || open) break;
                    model = topLeft;
                }
            }
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot).build();
        }, new Property[]{TallDoorBlock.POWERED, TallDoorBlock.WATERLOGGED});
    }
}

